/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.kratos.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="VerifiableAddress is an identity's verifiable address")
public class VerifiableIdentityAddress {
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static final String SERIALIZED_NAME_VERIFIED = "verified";
    @SerializedName(value="verified")
    private Boolean verified;
    public static final String SERIALIZED_NAME_VERIFIED_AT = "verified_at";
    @SerializedName(value="verified_at")
    private OffsetDateTime verifiedAt;
    public static final String SERIALIZED_NAME_VIA = "via";
    @SerializedName(value="via")
    private String via;

    public VerifiableIdentityAddress createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2014-01-01T23:28:56.782Z", value="When this entry was created")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public VerifiableIdentityAddress id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public VerifiableIdentityAddress status(String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="VerifiableAddressStatus must not exceed 16 characters as that is the limitation in the SQL Schema")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public VerifiableIdentityAddress updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2014-01-01T23:28:56.782Z", value="When this entry was last updated")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public VerifiableIdentityAddress value(String value) {
        this.value = value;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The address value  example foo@user.com")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public VerifiableIdentityAddress verified(Boolean verified) {
        this.verified = verified;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Indicates if the address has already been verified")
    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public VerifiableIdentityAddress verifiedAt(OffsetDateTime verifiedAt) {
        this.verifiedAt = verifiedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getVerifiedAt() {
        return this.verifiedAt;
    }

    public void setVerifiedAt(OffsetDateTime verifiedAt) {
        this.verifiedAt = verifiedAt;
    }

    public VerifiableIdentityAddress via(String via) {
        this.via = via;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="VerifiableAddressType must not exceed 16 characters as that is the limitation in the SQL Schema")
    public String getVia() {
        return this.via;
    }

    public void setVia(String via) {
        this.via = via;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifiableIdentityAddress verifiableIdentityAddress = (VerifiableIdentityAddress)o;
        return Objects.equals(this.createdAt, verifiableIdentityAddress.createdAt) && Objects.equals(this.id, verifiableIdentityAddress.id) && Objects.equals(this.status, verifiableIdentityAddress.status) && Objects.equals(this.updatedAt, verifiableIdentityAddress.updatedAt) && Objects.equals(this.value, verifiableIdentityAddress.value) && Objects.equals(this.verified, verifiableIdentityAddress.verified) && Objects.equals(this.verifiedAt, verifiableIdentityAddress.verifiedAt) && Objects.equals(this.via, verifiableIdentityAddress.via);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.id, this.status, this.updatedAt, this.value, this.verified, this.verifiedAt, this.via);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerifiableIdentityAddress {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    verified: ").append(this.toIndentedString(this.verified)).append("\n");
        sb.append("    verifiedAt: ").append(this.toIndentedString(this.verifiedAt)).append("\n");
        sb.append("    via: ").append(this.toIndentedString(this.via)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

