/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.log.aspect;

import cn.hutool.core.util.StrUtil;
import java.util.function.Function;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import sh.rime.reactor.core.context.ReactiveContextHolder;
import sh.rime.reactor.log.annotation.Log;
import sh.rime.reactor.log.aspect.JoinPointSerialise;

@Aspect
@Order(value=1)
public class ApiLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLogAspect.class);
    private final JoinPointSerialise joinPointSerialise;
    private final Function<Class<?>, Logger> loggerGetter;

    public ApiLogAspect(JoinPointSerialise joinPointSerialise) {
        this(joinPointSerialise, LoggerFactory::getLogger);
    }

    @Around(value="@annotation(log)")
    public Object handler(ProceedingJoinPoint joinPoint, Log log) throws Throwable {
        Object result = null;
        Throwable ex = null;
        Mono<?> monoResult = null;
        try {
            result = joinPoint.proceed();
        }
        catch (Throwable e) {
            ex = e;
            throw e;
        }
        finally {
            long start = System.currentTimeMillis();
            if (result instanceof Mono) {
                Mono monoResultTemp = (Mono)result;
                monoResult = this.logMonoResult(joinPoint, (Mono<? extends Tuple2<ServerHttpRequest, Object>>)ReactiveContextHolder.getExchange().map(ServerWebExchange::getRequest).zipWith(monoResultTemp), log, null);
            } else if (result instanceof Flux) {
                Flux fluxResult = (Flux)result;
                monoResult = this.logMonoResult(joinPoint, (Mono<? extends Tuple2<ServerHttpRequest, Object>>)ReactiveContextHolder.getExchange().map(ServerWebExchange::getRequest).zipWith(fluxResult.collectList()), log, null);
            } else if (ex != null) {
                Mono mono = Mono.error((Throwable)ex);
                monoResult = this.logMonoResult(joinPoint, (Mono<? extends Tuple2<ServerHttpRequest, Object>>)ReactiveContextHolder.getExchange().map(ServerWebExchange::getRequest).zipWith(mono), log, ex);
            } else {
                Mono mono = Mono.justOrEmpty((Object)result);
                monoResult = this.logMonoResult(joinPoint, (Mono<? extends Tuple2<ServerHttpRequest, Object>>)ReactiveContextHolder.getExchange().map(ServerWebExchange::getRequest).zipWith(mono), log, ex);
            }
        }
        return monoResult;
    }

    private Mono<?> logMonoResult(ProceedingJoinPoint joinPoint, Mono<? extends Tuple2<ServerHttpRequest, Object>> zipData, Log apiLog, Throwable ex) {
        Signature signature = joinPoint.getSignature();
        String logContent = StrUtil.trimToNull((CharSequence)apiLog.value());
        if (ex != null) {
            String serialisedJoinPoint = this.joinPointSerialise.serialise((JoinPoint)joinPoint, logContent, null, ex, null);
            Class declaringType = signature.getDeclaringType();
            Logger logger = this.loggerGetter.apply(declaringType);
            logger.error(serialisedJoinPoint);
        }
        return zipData.map(data -> {
            ServerHttpRequest request = (ServerHttpRequest)data.getT1();
            Object obj = data.getT2();
            if (!(signature instanceof MethodSignature)) {
                return obj;
            }
            String serialisedJoinPoint = this.joinPointSerialise.serialise((JoinPoint)joinPoint, logContent, request, ex, obj);
            Class declaringType = signature.getDeclaringType();
            Logger logger = this.loggerGetter.apply(declaringType);
            logger.info(serialisedJoinPoint);
            return obj;
        });
    }

    @Generated
    ApiLogAspect(JoinPointSerialise joinPointSerialise, Function<Class<?>, Logger> loggerGetter) {
        this.joinPointSerialise = joinPointSerialise;
        this.loggerGetter = loggerGetter;
    }
}

