/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.log.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import sh.rime.reactor.core.util.ReactiveAddrUtil;
import sh.rime.reactor.log.annotation.Log;
import sh.rime.reactor.log.aspect.LoggedMethod;
import sh.rime.reactor.log.aspect.UniqueMethodSignature;

public final class JoinPointSerialise {
    private static final Map<UniqueMethodSignature, LoggedMethod> CACHE = new ConcurrentHashMap<UniqueMethodSignature, LoggedMethod>();
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public String serialise(JoinPoint joinPoint, String logContent, ServerHttpRequest serverHttpRequest, Throwable ex, Object result) {
        String reset = "\u001b[0m";
        String cyan = "\u001b[36m";
        String yellow = "\u001b[33m";
        String green = "\u001b[32m";
        String red = "\u001b[31m";
        String magenta = "\u001b[35m";
        LoggedMethod loggedMethod = this.getLoggedMethod(joinPoint, logContent, serverHttpRequest);
        StringBuilder output = new StringBuilder();
        output.append("\u001b[36m").append("\n===== Log Entry Start =====\n").append("\u001b[0m");
        output.append("\u001b[33m").append("Logged Content    : ").append("\u001b[0m").append(loggedMethod.logContent()).append("\n").append("\u001b[33m").append("Method            : ").append("\u001b[0m").append(loggedMethod.className()).append("#").append(loggedMethod.methodName()).append("\n");
        if (serverHttpRequest != null) {
            output.append("\u001b[33m").append("Request URI       : ").append("\u001b[0m").append(loggedMethod.requestUri()).append("\n").append("\u001b[33m").append("Request Real IP   : ").append("\u001b[0m").append(loggedMethod.remoteAddr()).append("\n");
        }
        if (loggedMethod.params() != null && !loggedMethod.params().isEmpty()) {
            output.append("\u001b[32m").append("Parameters        : ").append("\u001b[0m").append("\n");
            for (Map.Entry<String, Object> entry : loggedMethod.params().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String formattedValue = this.formatAsJson(value);
                output.append("  ").append("\u001b[33m").append(key).append("\u001b[0m").append(" = ").append("\u001b[35m").append(formattedValue).append("\u001b[0m").append("\n");
            }
        }
        if (!loggedMethod.queryParamMap().isEmpty()) {
            output.append("\u001b[32m").append("Query Parameters  : ").append("\u001b[0m").append(loggedMethod.queryParamMap()).append("\n");
        }
        if (ex != null) {
            output.append("\u001b[31m").append("Exception         : ").append("\u001b[0m").append(ex.getMessage()).append("\n");
        } else if (result != null) {
            output.append("\u001b[35m").append("Result            : ").append("\u001b[0m").append(this.formatAsJson(result)).append("\n");
        }
        output.append("\u001b[36m").append("===== Log Entry End =====").append("\u001b[0m");
        return output.toString();
    }

    private String formatAsJson(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            return "Error serializing result: " + e.getMessage();
        }
    }

    private LoggedMethod getLoggedMethod(JoinPoint joinPoint, String logContent, ServerHttpRequest serverHttpRequest) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        UniqueMethodSignature uniqueMethodSignature = new UniqueMethodSignature(methodSignature);
        return CACHE.computeIfAbsent(uniqueMethodSignature, key -> this.buildLoggedMethod((UniqueMethodSignature)key, logContent, serverHttpRequest, args));
    }

    private LoggedMethod buildLoggedMethod(UniqueMethodSignature uniqueMethodSignature, String logContent, ServerHttpRequest request, Object[] args) {
        MethodSignature methodSignature = uniqueMethodSignature.getMethodSignature();
        Method method = methodSignature.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        String[] parameterNames = methodSignature.getParameterNames();
        Set<Integer> includedParameterIndexes = this.getIncludedParameterIndexes(method);
        Map<String, Object> parameterMap = this.buildParameterMap(parameterNames, args, includedParameterIndexes);
        if (request == null) {
            return new LoggedMethod(logContent, "", className, methodName, parameterMap, "", Map.of());
        }
        String uri = request.getPath().value();
        String remoteAddr = ReactiveAddrUtil.getRemoteAddr((ServerHttpRequest)request);
        Map<String, Object> queryParamMap = Map.of();
        MultiValueMap queryParams = request.getQueryParams();
        if (!queryParams.isEmpty()) {
            queryParamMap = this.buildParamMap((MultiValueMap<String, String>)queryParams);
        }
        return new LoggedMethod(logContent, uri, className, methodName, parameterMap, remoteAddr, queryParamMap);
    }

    private Map<String, Object> buildParameterMap(String[] parameterNames, Object[] parameterValues, Set<Integer> includedIndexes) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (parameterNames != null && parameterValues != null && includedIndexes != null) {
            int length = Math.min(parameterNames.length, parameterValues.length);
            for (int i = 0; i < length; ++i) {
                if (!includedIndexes.contains(i)) continue;
                paramMap.put(parameterNames[i], parameterValues[i]);
            }
        }
        return paramMap;
    }

    private Map<String, Object> buildParamMap(MultiValueMap<String, String> parameterNames) {
        HashMap<String, Object> params = new HashMap<String, Object>(parameterNames.size());
        parameterNames.forEach((key, value) -> {
            if (value.size() == 1) {
                params.put((String)key, value.getFirst());
            } else {
                params.put((String)key, value);
            }
        });
        return params;
    }

    private Set<Integer> getIncludedParameterIndexes(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        HashSet<Integer> includedParameterIndexes = new HashSet<Integer>();
        int n = parameterAnnotations.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            boolean log = Stream.of(annotations).map(Annotation::annotationType).noneMatch(Log.Exclude.class::equals);
            if (!log) continue;
            includedParameterIndexes.add(i);
        }
        return includedParameterIndexes;
    }
}

