/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.log.handler;

import cn.hutool.json.JSONUtil;
import lombok.Generated;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import sh.rime.reactor.core.util.OptionalBean;
import sh.rime.reactor.log.annotation.Log;
import sh.rime.reactor.log.handler.LogDomain;
import sh.rime.reactor.log.handler.LogHandler;

public class SimpleLogHandler
implements LogHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleLogHandler.class);

    @Override
    public boolean accept(MethodSignature methodSignature, Log log) {
        return log.enable();
    }

    @Override
    public Mono<Boolean> handler(LogDomain logDomain) {
        Object logStr = "logContent: {}, requestMethod: {}, requestUri: {}, requestId: {}, ip: {}, traceId: {}, queryParams: {}, operationParam: {}, result: {}";
        Throwable ex = logDomain.getEx();
        String logContent = logDomain.getLogContent();
        String requestMethod = logDomain.getRequestMethod();
        String requestUri = logDomain.getRequestUri();
        String requestId = logDomain.getRequestId();
        String ip = logDomain.getIp();
        String traceId = logDomain.getTraceId();
        Object queryParams = logDomain.getQueryParams();
        Object operationParam = logDomain.getOperationParam();
        Object result = logDomain.getResult();
        if (ex == null) {
            log.info((String)logStr, new Object[]{logContent, requestMethod, requestUri, requestId, ip, traceId, JSONUtil.toJsonStr((Object)queryParams), JSONUtil.toJsonStr((Object)operationParam), JSONUtil.toJsonStr((Object)result)});
            return Mono.just((Object)true);
        }
        logStr = (String)logStr + ", ex: {}";
        log.info((String)logStr, new Object[]{logContent, requestMethod, requestUri, requestId, traceId, ip, JSONUtil.toJsonStr((Object)operationParam), JSONUtil.toJsonStr((Object)result), OptionalBean.ofNullable((Object)ex).getBean(Throwable::getLocalizedMessage).orElse(null)});
        return Mono.just((Object)true);
    }
}

