/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.log.service;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import lombok.Generated;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import sh.rime.reactor.log.annotation.Log;
import sh.rime.reactor.log.handler.LogDomain;
import sh.rime.reactor.log.handler.LogHandler;

@Component
public class ApiLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLogService.class);
    private final ObjectProvider<LogHandler> logHandlersProvider;

    public ApiLogService(ObjectProvider<LogHandler> logHandlersProvider) {
        this.logHandlersProvider = logHandlersProvider;
    }

    @Async
    public void log(LogDomain logDomain, MethodSignature methodSignature, Log apiLog) {
        this.logHandlersProvider.stream().filter(handler -> handler.accept(methodSignature, apiLog)).forEach(handler -> this.logHandler(logDomain, (LogHandler)handler));
    }

    private void logHandler(LogDomain logDomain, LogHandler handler) {
        try {
            String traceId = this.getTraceId();
            logDomain.setTraceId(traceId);
            handler.handler(logDomain).subscribe();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String getTraceId() {
        Span span = Span.current();
        String traceId = "";
        if (span != null) {
            SpanContext spanContext = span.getSpanContext();
            traceId = spanContext.getTraceId();
        }
        return traceId;
    }
}

