/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.logging.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import cn.hutool.core.util.StrUtil;
import com.github.loki4j.logback.Loki4jAppender;
import com.github.loki4j.logback.PipelineConfigAppenderBase;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import sh.rime.reactor.logging.appender.ILoggingAppender;
import sh.rime.reactor.logging.properties.LoggingProperties;

public class LoggingLokiAppender
implements ILoggingAppender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingLokiAppender.class);
    private static final String APPENDER_NAME = "LOKI";
    private final LoggingProperties properties;
    private final String appName;
    private final String profile;

    public LoggingLokiAppender(Environment environment, LoggingProperties properties) {
        this.properties = properties;
        this.appName = environment.getRequiredProperty("spring.application.name");
        this.profile = environment.getRequiredProperty("spring.profiles.active");
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void reload(LoggerContext context) {
        LoggingProperties.Loki loki = this.properties.getLoki();
        if (loki.isEnabled()) {
            this.addLokiAppender(context, loki);
        }
    }

    private void addLokiAppender(LoggerContext context, LoggingProperties.Loki properties) {
        Loki4jAppender lokiAppender = new Loki4jAppender();
        lokiAppender.setName(APPENDER_NAME);
        lokiAppender.setContext((Context)context);
        PipelineConfigAppenderBase.BatchCfg batchCfg = new PipelineConfigAppenderBase.BatchCfg();
        batchCfg.setMaxItems(properties.getBatchMaxItems());
        batchCfg.setMaxBytes(properties.getBatchMaxBytes());
        batchCfg.setTimeoutMs(properties.getBatchTimeoutMs());
        batchCfg.setSendQueueMaxBytes(properties.getSendQueueMaxBytes());
        batchCfg.setUseDirectBuffers(properties.isUseDirectBuffers());
        batchCfg.setDrainOnStop(properties.isDrainOnStop());
        lokiAppender.setBatch(batchCfg);
        lokiAppender.setMetricsEnabled(properties.isMetricsEnabled());
        lokiAppender.setVerbose(properties.isVerbose());
        PatternLayout patternLayout = new PatternLayout();
        String formatMessagePattern = properties.getFormatMessagePattern();
        if (StrUtil.isNotBlank((CharSequence)formatMessagePattern)) {
            patternLayout.setPattern(formatMessagePattern);
        }
        lokiAppender.setMessage((Layout)patternLayout);
        String labelsPattern = this.formatLabelPatternHandle(context, properties);
        lokiAppender.setLabels(labelsPattern);
        lokiAppender.setContext((Context)context);
        lokiAppender.setHttp(LoggingLokiAppender.getSender(properties));
        lokiAppender.start();
        context.getLogger("ROOT").detachAppender(APPENDER_NAME);
        context.getLogger("ROOT").addAppender((Appender)lokiAppender);
    }

    private static PipelineConfigAppenderBase.HttpCfg getSender(LoggingProperties.Loki properties) {
        PipelineConfigAppenderBase.HttpCfg httpCfg = new PipelineConfigAppenderBase.HttpCfg();
        httpCfg.setUrl(properties.getHttpUrl());
        httpCfg.setConnectionTimeoutMs(properties.getHttpConnectionTimeoutMs());
        httpCfg.setRequestTimeoutMs(properties.getHttpRequestTimeoutMs());
        String authUsername = properties.getHttpAuthUsername();
        String authPassword = properties.getHttpAuthPassword();
        if (StrUtil.isNotBlank((CharSequence)authUsername) && StrUtil.isNotBlank((CharSequence)authPassword)) {
            PipelineConfigAppenderBase.BasicAuth basicAuth = new PipelineConfigAppenderBase.BasicAuth();
            basicAuth.setUsername(authUsername);
            basicAuth.setPassword(authPassword);
            httpCfg.setAuth(basicAuth);
        }
        httpCfg.setTenantId(properties.getHttpTenantId());
        return httpCfg;
    }

    private String formatLabelPatternHandle(LoggerContext context, LoggingProperties.Loki properties) {
        Object labelsPattern = properties.getFormatLabelPattern();
        Assert.hasText((String)labelsPattern, (String)"ShoreLoggingProperties shore.logging.loki.format-label-pattern is blank.");
        String labelPatternExtend = properties.getFormatLabelPatternExtend();
        if (StrUtil.isNotBlank((CharSequence)labelPatternExtend)) {
            labelsPattern = (String)labelsPattern + "\n" + labelPatternExtend;
        }
        return ((String)labelsPattern).replace("${appName}", this.appName).replace("${profile}", this.profile).replace("${HOSTNAME}", context.getProperty("HOSTNAME"));
    }
}

