/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.logging.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sh.rime.reactor.logging.appender.ILoggingAppender;
import sh.rime.reactor.logging.properties.LoggingProperties;

public class LoggingOpenTelemetryAppender
implements ILoggingAppender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingOpenTelemetryAppender.class);
    private static final String APPENDER_NAME = "OpenTelemetry";
    private final LoggingProperties properties;

    public LoggingOpenTelemetryAppender(LoggingProperties properties) {
        this.properties = properties;
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void reload(LoggerContext context) {
        LoggingProperties.OpenTelemetry openTelemetry = this.properties.getOtel();
        if (openTelemetry.isEnabled()) {
            this.addOpenTelemetryAppender(context);
        }
    }

    private void addOpenTelemetryAppender(LoggerContext context) {
        OpenTelemetryAppender openTelemetryAppender = new OpenTelemetryAppender();
        openTelemetryAppender.setName(APPENDER_NAME);
        openTelemetryAppender.setContext((Context)context);
        openTelemetryAppender.start();
        context.getLogger("ROOT").detachAppender(APPENDER_NAME);
        context.getLogger("ROOT").addAppender((Appender)openTelemetryAppender);
    }
}

