/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.logging.autoconfigure;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import sh.rime.reactor.logging.appender.Appender;
import sh.rime.reactor.logging.appender.ILoggingAppender;
import sh.rime.reactor.logging.appender.LoggingFileAppender;
import sh.rime.reactor.logging.appender.LoggingLokiAppender;
import sh.rime.reactor.logging.appender.LoggingOpenTelemetryAppender;
import sh.rime.reactor.logging.listener.LogbackLoggerContextListener;
import sh.rime.reactor.logging.listener.LoggingStartedEventListener;
import sh.rime.reactor.logging.properties.LoggingProperties;

@AutoConfiguration
@Order(value=-2147483648)
@EnableConfigurationProperties(value={LoggingProperties.class})
public class LoggingConfiguration {
    public static final String ENABLED = ".enabled";

    @Bean
    public LoggingStartedEventListener loggingStartedEventListener(LoggingProperties loggingProperties) {
        return new LoggingStartedEventListener(loggingProperties);
    }

    @Bean
    public LogbackLoggerContextListener logbackLoggerContextListener(ObjectProvider<ILoggingAppender> loggingAppenderObjectProvider) {
        List<ILoggingAppender> loggingAppenderList = loggingAppenderObjectProvider.orderedStream().toList();
        return new LogbackLoggerContextListener(loggingAppenderList);
    }

    @Order(value=-2147483648)
    private static final class LoggingCondition
    extends SpringBootCondition {
        private static final String LOKI_CLASS_NAME = "com.github.loki4j.logback.Loki4jAppender";
        private static final String OPEN_TELEMETRY_CLASS_NAME = "io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender";

        private LoggingCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Map attributes = metadata.getAnnotationAttributes(ConditionalOnAppender.class.getName());
            Object value = Objects.requireNonNull(attributes).get("value");
            Appender appender = Appender.valueOf(value.toString());
            Environment environment = context.getEnvironment();
            ClassLoader classLoader = context.getClassLoader();
            Boolean fileEnabled = (Boolean)environment.getProperty("shore.logging.files.enabled", Boolean.class, (Object)Boolean.TRUE);
            Boolean lokiEnabled = (Boolean)environment.getProperty("shore.logging.loki.enabled", Boolean.class, (Object)Boolean.FALSE);
            Boolean openTelemetryEnabled = (Boolean)environment.getProperty("shore.logging.otel.enabled", Boolean.class, (Object)Boolean.FALSE);
            if (Appender.LOKI == appender) {
                if (Boolean.FALSE.equals(lokiEnabled)) {
                    return ConditionOutcome.noMatch((String)"Logging loki is not enabled.");
                }
                if (LoggingCondition.hasLokiDependencies(classLoader)) {
                    return ConditionOutcome.match();
                }
                throw new IllegalStateException("Logging loki is enabled, please add com.github.loki4j loki-logback-appender dependencies.");
            }
            if (Appender.OPEN_TELEMETRY == appender) {
                if (Boolean.FALSE.equals(openTelemetryEnabled)) {
                    return ConditionOutcome.noMatch((String)"Logging openTelemetry is not enabled.");
                }
                if (LoggingCondition.hasOpenTelemetryDependencies(classLoader)) {
                    return ConditionOutcome.match();
                }
                throw new IllegalStateException("Logging openTelemetry is enabled, please add io.opentelemetry.instrumentation opentelemetry-logback-appender-1.0 dependencies.");
            }
            ConditionOutcome conditionOutcome = Appender.FILE == appender ? (Boolean.FALSE.equals(fileEnabled) ? ConditionOutcome.noMatch((String)"Logging logstash is not enabled.") : ConditionOutcome.match()) : ConditionOutcome.match();
            return conditionOutcome;
        }

        private static boolean hasLokiDependencies(ClassLoader classLoader) {
            return ClassUtils.isPresent((String)LOKI_CLASS_NAME, (ClassLoader)classLoader);
        }

        private static boolean hasOpenTelemetryDependencies(ClassLoader classLoader) {
            return ClassUtils.isPresent((String)OPEN_TELEMETRY_CLASS_NAME, (ClassLoader)classLoader);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={LoggingCondition.class})
    private static @interface ConditionalOnAppender {
        public Appender value();
    }

    @AutoConfiguration
    @ConditionalOnAppender(value=Appender.OPEN_TELEMETRY)
    public static class LoggingOpenTelemetryConfiguration {
        @Bean
        public LoggingOpenTelemetryAppender loggingLokiAppender(LoggingProperties properties) {
            return new LoggingOpenTelemetryAppender(properties);
        }
    }

    @AutoConfiguration
    @ConditionalOnAppender(value=Appender.LOKI)
    public static class LoggingLokiConfiguration {
        @Bean
        public LoggingLokiAppender loggingLokiAppender(Environment environment, LoggingProperties properties) {
            return new LoggingLokiAppender(environment, properties);
        }
    }

    @AutoConfiguration
    @ConditionalOnAppender(value=Appender.FILE)
    public static class LoggingFileConfiguration {
        @Bean
        public LoggingFileAppender loggingFileAppender(Environment environment, LoggingProperties properties) {
            return new LoggingFileAppender(environment, properties);
        }
    }
}

