/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.logging.listener;

import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import sh.rime.reactor.logging.properties.LoggingProperties;
import sh.rime.reactor.logging.utils.LoggingUtil;

public class LoggingStartedEventListener {
    private final LoggingProperties properties;

    public LoggingStartedEventListener(LoggingProperties properties) {
        this.properties = properties;
    }

    @Async
    @Order
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart() {
        LoggingProperties.Console console = this.properties.getConsole();
        if (console.isCloseAfterStart()) {
            LoggingUtil.detachAppender("CONSOLE");
        }
    }
}

