/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.logging.loki;

import com.github.loki4j.client.http.HttpConfig;
import com.github.loki4j.client.http.Loki4jHttpClient;
import com.github.loki4j.client.http.LokiResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Loki4jOkHttpClient
implements Loki4jHttpClient {
    private final HttpConfig conf;
    private final OkHttpClient httpClient;
    private final MediaType mediaType;
    private final Request requestBuilder;
    private byte[] bodyBuffer = new byte[0];

    public Loki4jOkHttpClient(HttpConfig conf) {
        this.conf = conf;
        this.httpClient = Loki4jOkHttpClient.okHttpClientBuilder(conf);
        this.mediaType = MediaType.get((String)conf.contentType);
        this.requestBuilder = Loki4jOkHttpClient.requestBuilder(conf);
    }

    private static OkHttpClient okHttpClientBuilder(HttpConfig conf) {
        return new OkHttpClient.Builder().connectTimeout(conf.connectionTimeoutMs, TimeUnit.MICROSECONDS).writeTimeout(conf.requestTimeoutMs, TimeUnit.MICROSECONDS).readTimeout(conf.requestTimeoutMs, TimeUnit.MICROSECONDS).build();
    }

    private static Request requestBuilder(HttpConfig conf) {
        Request.Builder request = new Request.Builder().url(conf.pushUrl).addHeader("Content-Type", conf.contentType);
        conf.tenantId.ifPresent(tenant -> request.addHeader("X-Scope-OrgID", tenant));
        conf.basicAuthToken().ifPresent(token -> request.addHeader("Authorization", "Basic " + token));
        return request.build();
    }

    public HttpConfig getConfig() {
        return this.conf;
    }

    public LokiResponse send(ByteBuffer batch) {
        LokiResponse lokiResponse;
        block11: {
            Request.Builder request = this.requestBuilder.newBuilder();
            if (batch.hasArray()) {
                request.post(RequestBody.create((byte[])batch.array(), (MediaType)this.mediaType, (int)batch.position(), (int)batch.remaining()));
            } else {
                int len = batch.remaining();
                if (len > this.bodyBuffer.length) {
                    this.bodyBuffer = new byte[len];
                }
                batch.get(this.bodyBuffer, 0, len);
                request.post(RequestBody.create((byte[])this.bodyBuffer, (MediaType)this.mediaType, (int)0, (int)len));
            }
            Call call = this.httpClient.newCall(request.build());
            Response response = call.execute();
            try {
                String body = response.body().string();
                lokiResponse = new LokiResponse(response.code(), body);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error while sending batch to Loki", e);
                }
            }
            response.close();
        }
        return lokiResponse;
    }

    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        Cache cache = this.httpClient.cache();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while closing OkHttpClient cache", e);
            }
        }
    }
}

