/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.logging.properties;

import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(value="shore.logging")
public class LoggingProperties {
    public static final String PREFIX = "shore.logging";
    private final Console console = new Console();
    private final Files files = new Files();
    private final Loki loki = new Loki();
    private final OpenTelemetry otel = new OpenTelemetry();

    @Generated
    public Console getConsole() {
        return this.console;
    }

    @Generated
    public Files getFiles() {
        return this.files;
    }

    @Generated
    public Loki getLoki() {
        return this.loki;
    }

    @Generated
    public OpenTelemetry getOtel() {
        return this.otel;
    }

    public static class Console {
        private boolean closeAfterStart = false;

        @Generated
        public boolean isCloseAfterStart() {
            return this.closeAfterStart;
        }

        @Generated
        public void setCloseAfterStart(boolean closeAfterStart) {
            this.closeAfterStart = closeAfterStart;
        }
    }

    public static class Files {
        public static final String PREFIX = "shore.logging.files";
        private boolean enabled = true;
        private boolean useJsonFormat = false;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isUseJsonFormat() {
            return this.useJsonFormat;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setUseJsonFormat(boolean useJsonFormat) {
            this.useJsonFormat = useJsonFormat;
        }
    }

    public static class Loki {
        public static final String PREFIX = "shore.logging.loki";
        private boolean enabled = false;
        private int batchMaxItems = 1000;
        private int batchMaxBytes = 0x400000;
        private long batchTimeoutMs = 60000L;
        private long sendQueueMaxBytes = 0x2800000L;
        private boolean useDirectBuffers = true;
        private boolean drainOnStop = true;
        private boolean metricsEnabled = false;
        private boolean verbose = false;
        private String httpUrl = "http://localhost:3100/loki/api/v1/push";
        private long httpConnectionTimeoutMs = 30000L;
        private long httpRequestTimeoutMs = 5000L;
        private String httpAuthUsername;
        private String httpAuthPassword;
        private String httpTenantId;
        private String formatLabelPattern = "app=${appName}\nprofile=${profile}\nhost=${HOSTNAME}\nlevel=%level\nthread=%thread\ntraceID=%X{trace_id:-NONE}";
        private String formatLabelPatternExtend;
        private String formatLabelPairSeparator = ",";
        private String formatLabelKeyValueSeparator = "=";
        private String formatMessagePattern = "level=%level class=%logger{20} thread=%thread traceID=%X{trace_id} | %msg %ex";

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public int getBatchMaxItems() {
            return this.batchMaxItems;
        }

        @Generated
        public int getBatchMaxBytes() {
            return this.batchMaxBytes;
        }

        @Generated
        public long getBatchTimeoutMs() {
            return this.batchTimeoutMs;
        }

        @Generated
        public long getSendQueueMaxBytes() {
            return this.sendQueueMaxBytes;
        }

        @Generated
        public boolean isUseDirectBuffers() {
            return this.useDirectBuffers;
        }

        @Generated
        public boolean isDrainOnStop() {
            return this.drainOnStop;
        }

        @Generated
        public boolean isMetricsEnabled() {
            return this.metricsEnabled;
        }

        @Generated
        public boolean isVerbose() {
            return this.verbose;
        }

        @Generated
        public String getHttpUrl() {
            return this.httpUrl;
        }

        @Generated
        public long getHttpConnectionTimeoutMs() {
            return this.httpConnectionTimeoutMs;
        }

        @Generated
        public long getHttpRequestTimeoutMs() {
            return this.httpRequestTimeoutMs;
        }

        @Generated
        public String getHttpAuthUsername() {
            return this.httpAuthUsername;
        }

        @Generated
        public String getHttpAuthPassword() {
            return this.httpAuthPassword;
        }

        @Generated
        public String getHttpTenantId() {
            return this.httpTenantId;
        }

        @Generated
        public String getFormatLabelPattern() {
            return this.formatLabelPattern;
        }

        @Generated
        public String getFormatLabelPatternExtend() {
            return this.formatLabelPatternExtend;
        }

        @Generated
        public String getFormatLabelPairSeparator() {
            return this.formatLabelPairSeparator;
        }

        @Generated
        public String getFormatLabelKeyValueSeparator() {
            return this.formatLabelKeyValueSeparator;
        }

        @Generated
        public String getFormatMessagePattern() {
            return this.formatMessagePattern;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setBatchMaxItems(int batchMaxItems) {
            this.batchMaxItems = batchMaxItems;
        }

        @Generated
        public void setBatchMaxBytes(int batchMaxBytes) {
            this.batchMaxBytes = batchMaxBytes;
        }

        @Generated
        public void setBatchTimeoutMs(long batchTimeoutMs) {
            this.batchTimeoutMs = batchTimeoutMs;
        }

        @Generated
        public void setSendQueueMaxBytes(long sendQueueMaxBytes) {
            this.sendQueueMaxBytes = sendQueueMaxBytes;
        }

        @Generated
        public void setUseDirectBuffers(boolean useDirectBuffers) {
            this.useDirectBuffers = useDirectBuffers;
        }

        @Generated
        public void setDrainOnStop(boolean drainOnStop) {
            this.drainOnStop = drainOnStop;
        }

        @Generated
        public void setMetricsEnabled(boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
        }

        @Generated
        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        @Generated
        public void setHttpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
        }

        @Generated
        public void setHttpConnectionTimeoutMs(long httpConnectionTimeoutMs) {
            this.httpConnectionTimeoutMs = httpConnectionTimeoutMs;
        }

        @Generated
        public void setHttpRequestTimeoutMs(long httpRequestTimeoutMs) {
            this.httpRequestTimeoutMs = httpRequestTimeoutMs;
        }

        @Generated
        public void setHttpAuthUsername(String httpAuthUsername) {
            this.httpAuthUsername = httpAuthUsername;
        }

        @Generated
        public void setHttpAuthPassword(String httpAuthPassword) {
            this.httpAuthPassword = httpAuthPassword;
        }

        @Generated
        public void setHttpTenantId(String httpTenantId) {
            this.httpTenantId = httpTenantId;
        }

        @Generated
        public void setFormatLabelPattern(String formatLabelPattern) {
            this.formatLabelPattern = formatLabelPattern;
        }

        @Generated
        public void setFormatLabelPatternExtend(String formatLabelPatternExtend) {
            this.formatLabelPatternExtend = formatLabelPatternExtend;
        }

        @Generated
        public void setFormatLabelPairSeparator(String formatLabelPairSeparator) {
            this.formatLabelPairSeparator = formatLabelPairSeparator;
        }

        @Generated
        public void setFormatLabelKeyValueSeparator(String formatLabelKeyValueSeparator) {
            this.formatLabelKeyValueSeparator = formatLabelKeyValueSeparator;
        }

        @Generated
        public void setFormatMessagePattern(String formatMessagePattern) {
            this.formatMessagePattern = formatMessagePattern;
        }
    }

    public static class OpenTelemetry {
        public static final String PREFIX = "shore.logging.otel";
        private boolean enabled = false;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static enum HttpSender {
        JAVA11("java.net.http.HttpClient"),
        OK_HTTP("okhttp3.OkHttpClient"),
        APACHE_HTTP("org.apache.http.impl.client.HttpClients");

        private final String senderClass;

        public boolean isAvailable() {
            return ClassUtils.isPresent((String)this.senderClass, null);
        }

        @Generated
        public String getSenderClass() {
            return this.senderClass;
        }

        @Generated
        private HttpSender(String senderClass) {
            this.senderClass = senderClass;
        }
    }

    public static enum LokiEncoder {
        JSON,
        PROTOBUF;

    }
}

