/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.logging.utils;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import java.util.Objects;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.logback.RollingPolicySystemProperty;
import org.springframework.lang.Nullable;

public final class LoggingUtil {
    public static final String DEFAULT_LOG_DIR = "logs";
    public static final String LOG_FILE_ALL = "all.log";
    public static final String LOG_FILE_ERROR = "error.log";
    public static final String CONSOLE_APPENDER_NAME = "CONSOLE";
    public static final String FILE_APPENDER_NAME = "FILE";
    public static final String FILE_ERROR_APPENDER_NAME = "FILE_ERROR";
    public static final String DEFAULT_FILE_LOG_PATTERN = "${FILE_LOG_PATTERN:%d{${LOG_DATEFORMAT_PATTERN:yyyy-MM-dd HH:mm:ss.SSS}} ${LOG_LEVEL_PATTERN:%5p} ${PID:} --- [%t] %-40.40logger{39} : %m%n${LOG_EXCEPTION_CONVERSION_WORD:%wEx}}";
    private static final String TRUE = "true";
    private static final String Y = "y";
    private static final String YES = "yes";
    private static final String ONE = "1";
    private static final String ON = "on";
    private static final String FALSE = "false";
    private static final String N = "n";
    private static final String NO = "no";
    private static final String OFF = "off";
    private static final String ZERO = "0";

    private LoggingUtil() {
    }

    public static void detachAppender(String name) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.getLogger("ROOT").detachAppender(name);
    }

    public static RollingPolicy rollingPolicy(LoggerContext context, FileAppender<?> appender, String logErrorFile) {
        SizeAndTimeBasedRollingPolicy rollingPolicy = new SizeAndTimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setCleanHistoryOnStart(LoggingUtil.getPropToBool());
        rollingPolicy.setFileNamePattern(logErrorFile + ".%d{yyyy-MM-dd}.%i.gz");
        rollingPolicy.setMaxFileSize(FileSize.valueOf((String)LoggingUtil.getProp(RollingPolicySystemProperty.MAX_FILE_SIZE.getEnvironmentVariableName(), "10MB")));
        rollingPolicy.setMaxHistory(LoggingUtil.toInt(RollingPolicySystemProperty.MAX_HISTORY.getEnvironmentVariableName(), 7));
        rollingPolicy.setTotalSizeCap(FileSize.valueOf((String)LoggingUtil.getProp(RollingPolicySystemProperty.TOTAL_SIZE_CAP.getEnvironmentVariableName(), ZERO)));
        rollingPolicy.setParent(appender);
        rollingPolicy.start();
        return rollingPolicy;
    }

    public static String getProp(String key, String defValue) {
        return System.getProperty(key, defValue);
    }

    public static int toInt(@Nullable Object object, int defaultValue) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.intValue();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Boolean toBoolean(@Nullable Object object, @Nullable Boolean defaultValue) {
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            if (TRUE.equalsIgnoreCase(value) || Y.equalsIgnoreCase(value) || YES.equalsIgnoreCase(value) || ON.equalsIgnoreCase(value) || ONE.equalsIgnoreCase(value)) {
                return true;
            }
            if (FALSE.equalsIgnoreCase(value) || N.equalsIgnoreCase(value) || NO.equalsIgnoreCase(value) || OFF.equalsIgnoreCase(value) || ZERO.equalsIgnoreCase(value)) {
                return false;
            }
        }
        return defaultValue;
    }

    public static String getProp(String key) {
        return System.getProperty(key);
    }

    private static boolean getPropToBool() {
        return Objects.requireNonNull(LoggingUtil.toBoolean(LoggingUtil.getProp(RollingPolicySystemProperty.CLEAN_HISTORY_ON_START.getEnvironmentVariableName()), false));
    }
}

