/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.redis;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import reactor.core.publisher.Flux;
import sh.rime.reactor.redis.supprot.CustomizeReactiveRedisTemplate;
import sh.rime.reactor.redis.supprot.CustomizeRedisTemplate;
import sh.rime.reactor.redis.util.JacksonSerializerUtils;
import sh.rime.reactor.redis.util.ReactiveRedisUtil;

@ConditionalOnClass(value={RedisOperations.class})
@AutoConfiguration(before={RedisAutoConfiguration.class})
public class CustomizeRedisAutoConfiguration {
    @Bean
    public CustomizeRedisTemplate customizeRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return new CustomizeRedisTemplate(redisConnectionFactory);
    }

    @Bean
    @ConditionalOnBean(name={"customizeReactiveRedisTemplate"})
    public ReactiveRedisUtil reactiveRedisUtil(CustomizeReactiveRedisTemplate<String, Object> customizeReactiveRedisTemplate) {
        return new ReactiveRedisUtil(customizeReactiveRedisTemplate);
    }

    @AutoConfiguration(before={RedisReactiveAutoConfiguration.class})
    @ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, ReactiveRedisTemplate.class, Flux.class})
    public static class CustomizeReactiveRedisAutoConfiguration {
        @Bean(value={"customizeReactiveRedisTemplate"})
        public CustomizeReactiveRedisTemplate<String, Object> customizeReactiveRedisTemplate(ReactiveRedisConnectionFactory redisConnectionFactory) {
            RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(JacksonSerializerUtils.json()).hashKey(RedisSerializer.string()).hashValue(JacksonSerializerUtils.json()).build();
            return new CustomizeReactiveRedisTemplate<String, Object>(redisConnectionFactory, (RedisSerializationContext<String, Object>)serializationContext);
        }
    }
}

