/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.redis.util;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

public final class JacksonSerializerUtils {
    private JacksonSerializerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <T> RedisSerializer<T> json(Class<T> targetClass, ObjectMapper mapper) {
        return new Jackson2JsonRedisSerializer(mapper, targetClass);
    }

    public static <T> RedisSerializer<T> json(Class<T> targetClass) {
        return JacksonSerializerUtils.json(targetClass, new Module[]{new JavaTimeModule()});
    }

    public static <T> RedisSerializer<T> json(Class<T> targetClass, Module ... modules) {
        ObjectMapper mapper = JsonMapper.builder().build();
        mapper.registerModules(modules);
        mapper.activateDefaultTyping(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        return JacksonSerializerUtils.json(targetClass, mapper);
    }

    public static RedisSerializer<Object> json() {
        return JacksonSerializerUtils.json(Object.class);
    }
}

