/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.redis.util;

import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveHashOperations;
import org.springframework.data.redis.core.ReactiveValueOperations;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import sh.rime.reactor.redis.supprot.CustomizeReactiveRedisTemplate;

public class ReactiveRedisUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveRedisUtil.class);
    private final CustomizeReactiveRedisTemplate<String, Object> customizeReactiveRedisTemplate;

    public ReactiveRedisUtil(CustomizeReactiveRedisTemplate<String, Object> customizeReactiveRedisTemplate) {
        this.customizeReactiveRedisTemplate = customizeReactiveRedisTemplate;
    }

    public Mono<Long> increment(String key, long delta) {
        return this.customizeReactiveRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Mono<Boolean> expire(String key, Duration timeout) {
        return this.customizeReactiveRedisTemplate.expire(key, timeout);
    }

    public Mono<Duration> getExpire(String key) {
        return this.customizeReactiveRedisTemplate.getExpire(key);
    }

    public Mono<Boolean> hasKey(String key) {
        return this.customizeReactiveRedisTemplate.hasKey(key);
    }

    public Mono<Long> del(String key) {
        return this.customizeReactiveRedisTemplate.delete(new String[]{key});
    }

    public <T> Mono<T> get(String key) {
        if (key == null) {
            return Mono.empty();
        }
        ReactiveValueOperations stringObjectReactiveValueOperations = this.customizeReactiveRedisTemplate.opsForValue();
        return stringObjectReactiveValueOperations.get((Object)key).doOnSuccess(o -> log.debug("get key:{} value:{}", (Object)key, o));
    }

    public Mono<Boolean> set(String key, Object value) {
        return this.customizeReactiveRedisTemplate.opsForValue().set((Object)key, value);
    }

    public Mono<Boolean> set(String key, Object value, Duration time) {
        return this.customizeReactiveRedisTemplate.opsForValue().set((Object)key, value, time);
    }

    public <T> Mono<T> hashGet(String key, String item) {
        ReactiveHashOperations stringObjectObjectReactiveHashOperations = this.customizeReactiveRedisTemplate.opsForHash();
        return stringObjectObjectReactiveHashOperations.get((Object)key, (Object)item);
    }

    public Mono<Boolean> hashSet(String key, Map<String, Object> map) {
        return this.customizeReactiveRedisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Mono<Boolean> hSet(String key, String item, Object value, Long time) {
        return this.customizeReactiveRedisTemplate.opsForHash().put((Object)key, (Object)item, value).filter(flag -> time > 0L).flatMap(flag -> this.expire(key, Duration.ofSeconds(time)));
    }

    public Mono<Boolean> hashSet(String key, Map<String, Object> map, Duration time) {
        return this.customizeReactiveRedisTemplate.opsForHash().putAll((Object)key, map).flatMap(flag -> this.expire(key, time));
    }

    public Flux<Map.Entry<Object, Object>> hmget(String key) {
        return this.customizeReactiveRedisTemplate.opsForHash().entries((Object)key);
    }
}

