/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.web.autoconfigure;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import sh.rime.reactor.commons.enums.EnvEnum;

@Configuration
public class SwaggerConfiguration {
    private final Environment env;

    public SwaggerConfiguration(Environment env) {
        this.env = env;
    }

    @Bean
    public OpenAPI customOpenAPI() {
        Contact contact = new Contact().name("youta").email("youta@irain.io").url("https://www.irain.io/").extensions(new HashMap());
        License license = new License().name("Apache 2.0").url("https://www.apache.org/licenses/LICENSE-2.0.html").identifier("Apache-2.0").extensions(new HashMap());
        Info info = new Info().title("\u670d\u52a1\u7aef\u63a5\u53e3\u6587\u6863").description("\u670d\u52a1\u7aefapi\u63a5\u53e3\u6587\u6863").version("v1").termsOfService("https://api.irain.io/").license(license).contact(contact);
        SecurityScheme securityScheme = new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("Bearer").description("\u4ee4\u724c").name("Authorization").in(SecurityScheme.In.HEADER);
        String environment = this.env.getProperty("spring.profiles.active");
        ArrayList<Server> servers = new ArrayList<Server>();
        if (!EnvEnum.LOCAL.getEnv().equals(environment)) {
            servers.add(new Server().url("https://test.irain.io").description("Test server"));
            servers.add(new Server().url("https://api.irain.io").description("Production server"));
        }
        OpenAPI openAPI = new OpenAPI().openapi("3.1.0").info(info).components(new Components().addSecuritySchemes("BearerAuth", securityScheme)).addSecurityItem(new SecurityRequirement().addList("BearerAuth"));
        if (!servers.isEmpty()) {
            openAPI.servers(servers);
        }
        return openAPI;
    }
}

