/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.web.autoconfigure;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.AbstractErrorWebExceptionHandler;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;
import sh.rime.reactor.web.exception.GlobalExceptionHandler;
import sh.rime.reactor.web.exception.WebFluxErrorWebExceptionHandler;
import sh.rime.reactor.web.properties.GlobalExceptionProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={GlobalExceptionProperties.class})
public class WebFluxGlobalExceptionHandlerAutoConfigure {
    private final ServerProperties serverProperties;
    private final WebProperties.Resources resourceProperties;
    private final List<ViewResolver> viewResolvers;
    private final ServerCodecConfigurer serverCodecConfigurer;

    public WebFluxGlobalExceptionHandlerAutoConfigure(ServerProperties serverProperties, WebProperties webProperties, List<ViewResolver> viewResolvers, ServerCodecConfigurer serverCodecConfigurer) {
        this.serverProperties = serverProperties;
        this.resourceProperties = webProperties.getResources();
        this.viewResolvers = Collections.unmodifiableList(viewResolvers);
        this.serverCodecConfigurer = serverCodecConfigurer;
    }

    @Bean
    public GlobalExceptionHandler webFluxGlobalExceptionHandler(GlobalExceptionProperties globalExceptionProperties) {
        return new GlobalExceptionHandler(globalExceptionProperties);
    }

    @Order(value=-2)
    @Bean
    public AbstractErrorWebExceptionHandler webFluxErrorWebExceptionHandler(ErrorAttributes errorAttributes, ApplicationContext applicationContext, GlobalExceptionHandler globalExceptionHandler, GlobalExceptionProperties globalExceptionProperties) {
        WebFluxErrorWebExceptionHandler exceptionHandler = new WebFluxErrorWebExceptionHandler(errorAttributes, this.resourceProperties, this.serverProperties.getError(), applicationContext, globalExceptionHandler, globalExceptionProperties);
        exceptionHandler.setViewResolvers(this.viewResolvers);
        exceptionHandler.setMessageWriters(this.serverCodecConfigurer.getWriters());
        exceptionHandler.setMessageReaders(this.serverCodecConfigurer.getReaders());
        return exceptionHandler;
    }
}

