/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.web.exception;

import cn.hutool.core.util.StrUtil;
import java.lang.runtime.SwitchBootstraps;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import sh.rime.reactor.commons.bean.Result;
import sh.rime.reactor.commons.exception.ServerException;
import sh.rime.reactor.web.properties.GlobalExceptionProperties;

public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final GlobalExceptionProperties globalExceptionProperties;

    public GlobalExceptionHandler(GlobalExceptionProperties globalExceptionProperties) {
        this.globalExceptionProperties = globalExceptionProperties;
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<Result<?>> exceptionHandler0(ServerWebExchange serverWebExchange, Throwable e) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        String method = request.getMethod().name();
        String path = request.getPath().value();
        Result<?> result = this.build(e, method, path);
        int httpCode = this.globalExceptionProperties.getHttpCode();
        if (result.getCode() < 500) {
            httpCode = result.getCode();
        }
        return ResponseEntity.status((int)httpCode).body(result);
    }

    public Result<?> build(Throwable e, String method, String path) {
        log.debug("request failed", e);
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class);
        Result<Void> fail = Result.failed();
        String defaultMsg = "The system is busy. Please try again later.";
        if (responseStatus != null) {
            int errorCode = responseStatus.value().value();
            String message = responseStatus.reason();
            fail = Result.failed((Integer)errorCode, (String)message);
        } else if (StrUtil.isBlank((CharSequence)e.getMessage())) {
            fail = Result.failed((Integer)500, (String)defaultMsg);
        } else {
            Throwable throwable = e;
            Objects.requireNonNull(throwable);
            Throwable throwable2 = throwable;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodArgumentNotValidException.class, WebExchangeBindException.class, ResponseStatusException.class}, (Object)throwable2, n)) {
                case 0: {
                    MethodArgumentNotValidException validException = (MethodArgumentNotValidException)throwable2;
                    BindingResult bindingResult = validException.getBindingResult();
                    List errors = bindingResult.getAllErrors();
                    StringBuffer errorMsg = new StringBuffer();
                    errors.stream().map(this::getMethodArgumentNotValidExceptionDisplayMessage).forEach(x -> errorMsg.append((String)x).append(";"));
                    if (errorMsg.toString().endsWith(";")) {
                        errorMsg.deleteCharAt(errorMsg.length() - 1);
                    }
                    return Result.failed((Integer)400, (String)errorMsg.toString());
                }
                case 1: {
                    WebExchangeBindException bindException = (WebExchangeBindException)throwable2;
                    List fieldErrors = bindException.getFieldErrors();
                    String message = String.format("%s", fieldErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).map(this::getArgumentNotValidExceptionMessage).collect(Collectors.joining(";")));
                    return Result.failed((Integer)400, (String)message);
                }
                case 2: {
                    ResponseStatusException ignored = (ResponseStatusException)throwable2;
                    String msg = "Invalid request address[%s %s]";
                    return Result.failed((Integer)404, (String)String.format(msg, method, path));
                }
            }
            fail = this.serverException(e, fail);
            log.error("Request failed", e);
            fail.setException(e.getLocalizedMessage());
        }
        if (!this.globalExceptionProperties.getEnable().booleanValue()) {
            fail.setException(null);
        }
        return fail;
    }

    private String getMethodArgumentNotValidExceptionDisplayMessage(ObjectError error) {
        String defaultMessage = error.getDefaultMessage();
        if (defaultMessage == null) {
            return error.getDefaultMessage();
        }
        try {
            return defaultMessage;
        }
        catch (NoSuchMessageException e) {
            return error.getDefaultMessage();
        }
    }

    private Result<Void> serverException(Throwable cause, Result<Void> fail) {
        if (cause instanceof ServerException) {
            ServerException exception = (ServerException)cause;
            Throwable remoteEx = exception.getCause();
            fail = Result.failed((Integer)exception.getErrorCode(), (String)exception.getLocalizedMessage());
            if (remoteEx instanceof RemoteException) {
                RemoteException remoteException = (RemoteException)remoteEx;
                fail.setException(remoteException.getLocalizedMessage());
            }
            return fail;
        }
        return fail;
    }

    private String getArgumentNotValidExceptionMessage(String errorMessage) {
        if (errorMessage == null) {
            return null;
        }
        try {
            return errorMessage;
        }
        catch (NoSuchMessageException e) {
            return errorMessage;
        }
    }
}

