/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.web.exception;

import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import sh.rime.reactor.commons.bean.Result;
import sh.rime.reactor.web.exception.GlobalExceptionHandler;
import sh.rime.reactor.web.properties.GlobalExceptionProperties;
import sh.rime.reactor.web.util.RequestUtil;

public class WebFluxErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    private final GlobalExceptionHandler globalExceptionHandler;
    private final GlobalExceptionProperties globalExceptionProperties;

    public WebFluxErrorWebExceptionHandler(ErrorAttributes errorAttributes, WebProperties.Resources resources, ErrorProperties errorProperties, ApplicationContext applicationContext, GlobalExceptionHandler globalExceptionHandler, GlobalExceptionProperties globalExceptionProperties) {
        super(errorAttributes, resources, errorProperties, applicationContext);
        this.globalExceptionHandler = globalExceptionHandler;
        this.globalExceptionProperties = globalExceptionProperties;
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), this::renderErrorResponse);
    }

    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        String requestMethod = request.method().name();
        String requestPath = RequestUtil.parseRequestUri(request);
        Throwable error = this.getError(request);
        Result<?> fail = this.globalExceptionHandler.build(error, requestMethod, requestPath);
        int httpCode = this.globalExceptionProperties.getHttpCode();
        if (fail.getCode() < 500) {
            httpCode = fail.getCode();
        }
        return ServerResponse.status((int)httpCode).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue(fail));
    }
}

