/*
 * Decompiled with CFR 0.152.
 */
package sh.rime.reactor.web.handler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.WebSocketHandler;
import sh.rime.reactor.web.annotations.WebSocketMapping;

public class WebSocketMappingHandlerMapping
extends SimpleUrlHandlerMapping {
    private final Map<String, WebSocketHandler> handlerMap = new LinkedHashMap<String, WebSocketHandler>();

    public void initApplicationContext() {
        Map beanMap = this.obtainApplicationContext().getBeansWithAnnotation(WebSocketMapping.class);
        beanMap.values().forEach(bean -> {
            if (!(bean instanceof WebSocketHandler)) {
                throw new IllegalArgumentException(String.format("Controller [%s] doesn't implement WebSocketHandler interface.", bean.getClass().getName()));
            }
            WebSocketMapping annotation = (WebSocketMapping)AnnotationUtils.getAnnotation(bean.getClass(), WebSocketMapping.class);
            this.handlerMap.put(Objects.requireNonNull(annotation).value(), (WebSocketHandler)bean);
        });
        super.setOrder(Integer.MIN_VALUE);
        super.setUrlMap(this.handlerMap);
        super.initApplicationContext();
    }
}

