/*
 * Decompiled with CFR 0.152.
 */
package sh.tyy.wheelpicker;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.tyy.wheelpicker.R;
import sh.tyy.wheelpicker.core.BaseWheelPickerView;
import sh.tyy.wheelpicker.core.TextWheelAdapter;
import sh.tyy.wheelpicker.core.TextWheelPickerView;
import sh.tyy.wheelpicker.databinding.TriplePickerViewBinding;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\bH\u0016J\b\u00108\u001a\u000204H\u0002J\u0010\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020\u001fH\u0016J\u000e\u0010;\u001a\u0002042\u0006\u0010$\u001a\u00020%R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R\u000e\u0010)\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0011\"\u0004\b/\u0010\u0013R\u000e\u00100\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\b0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lsh/tyy/wheelpicker/WeekdayTimePickerView;", "Landroid/widget/FrameLayout;", "Lsh/tyy/wheelpicker/core/BaseWheelPickerView$WheelPickerViewListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lsh/tyy/wheelpicker/databinding/TriplePickerViewBinding;", "calendar", "Ljava/util/Calendar;", "value", "firstDayOfWeek", "getFirstDayOfWeek", "()I", "setFirstDayOfWeek", "(I)V", "formatter", "Ljava/text/SimpleDateFormat;", "highlightView", "Landroid/view/View;", "hour", "getHour", "setHour", "hourAdapter", "Lsh/tyy/wheelpicker/core/TextWheelAdapter;", "hourPickerView", "Lsh/tyy/wheelpicker/core/TextWheelPickerView;", "", "isCircular", "()Z", "setCircular", "(Z)V", "listener", "Lsh/tyy/wheelpicker/WeekdayTimePickerView$Listener;", "minute", "getMinute", "setMinute", "minuteAdapter", "minutePickerView", "normalWeekdays", "", "weekday", "getWeekday", "setWeekday", "weekdayAdapter", "weekdayPickerView", "weekdays", "didSelectItem", "", "picker", "Lsh/tyy/wheelpicker/core/BaseWheelPickerView;", "index", "refreshWeekdays", "setHapticFeedbackEnabled", "hapticFeedbackEnabled", "setWheelListener", "Listener", "WheelPicker_release"})
public final class WeekdayTimePickerView
extends FrameLayout
implements BaseWheelPickerView.WheelPickerViewListener {
    @NotNull
    private final View highlightView;
    @NotNull
    private final TextWheelPickerView weekdayPickerView;
    @NotNull
    private final TextWheelPickerView hourPickerView;
    @NotNull
    private final TextWheelPickerView minutePickerView;
    @NotNull
    private final List<Integer> normalWeekdays;
    @NotNull
    private List<Integer> weekdays;
    @Nullable
    private Listener listener;
    @NotNull
    private final SimpleDateFormat formatter;
    @NotNull
    private final Calendar calendar;
    private boolean isCircular;
    @NotNull
    private final TextWheelAdapter weekdayAdapter;
    @NotNull
    private final TextWheelAdapter hourAdapter;
    @NotNull
    private final TextWheelAdapter minuteAdapter;
    @NotNull
    private final TriplePickerViewBinding binding;

    @JvmOverloads
    public WeekdayTimePickerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TextWheelPickerView.Item item;
        int it;
        int item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Integer[] integerArray = this;
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = integerArray;
        Object object = this;
        boolean bl3 = false;
        Object view = new View(context);
        view.setBackground(ContextCompat.getDrawable((Context)context, (int)R.drawable.text_wheel_highlight_bg));
        Object object2 = view;
        ((WeekdayTimePickerView)object).highlightView = object2;
        integerArray = new Integer[]{1, 2, 3, 4, 5, 6, 7};
        this.normalWeekdays = CollectionsKt.listOf((Object[])integerArray);
        this.weekdays = this.normalWeekdays;
        this.formatter = new SimpleDateFormat("EEE");
        integerArray = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)integerArray, (String)"getInstance()");
        this.calendar = integerArray;
        this.weekdayAdapter = new TextWheelAdapter();
        this.hourAdapter = new TextWheelAdapter();
        this.minuteAdapter = new TextWheelAdapter();
        integerArray = TriplePickerViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)integerArray, (String)"inflate(LayoutInflater.from(context), this)");
        this.binding = integerArray;
        integerArray = this.binding.leftPicker;
        Intrinsics.checkNotNullExpressionValue((Object)integerArray, (String)"binding.leftPicker");
        this.weekdayPickerView = integerArray;
        this.weekdayPickerView.setAdapter(this.weekdayAdapter);
        integerArray = this.binding.midPicker;
        Intrinsics.checkNotNullExpressionValue((Object)integerArray, (String)"binding.midPicker");
        this.hourPickerView = integerArray;
        this.hourPickerView.setAdapter(this.hourAdapter);
        integerArray = (Iterable)RangesKt.until((int)0, (int)24);
        object = this.hourAdapter;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        view = $this$mapTo$iv$iv.iterator();
        while (view.hasNext()) {
            int n = item$iv$iv = ((IntIterator)view).nextInt();
            object2 = destination$iv$iv;
            boolean bl4 = false;
            item = new TextWheelPickerView.Item(String.valueOf(it), String.valueOf(it), false, 4, null);
            object2.add(item);
        }
        object2 = (List)destination$iv$iv;
        ((BaseWheelPickerView.Adapter)object).setValues(object2);
        $this$map$iv = this.binding.rightPicker;
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"binding.rightPicker");
        this.minutePickerView = $this$map$iv;
        this.minutePickerView.setAdapter(this.minuteAdapter);
        $this$map$iv = (Iterable)RangesKt.until((int)0, (int)60);
        object = this.minuteAdapter;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        view = $this$mapTo$iv$iv.iterator();
        while (view.hasNext()) {
            it = item$iv$iv = ((IntIterator)view).nextInt();
            object2 = destination$iv$iv;
            boolean bl5 = false;
            item = new TextWheelPickerView.Item(String.valueOf(it), String.valueOf(it), false, 4, null);
            object2.add(item);
        }
        object2 = (List)destination$iv$iv;
        ((BaseWheelPickerView.Adapter)object).setValues(object2);
        this.addView(this.highlightView);
        ViewGroup.LayoutParams layoutParams = this.highlightView.getLayoutParams();
        Integer[] integerArray2 = integerArray = layoutParams instanceof FrameLayout.LayoutParams ? (Integer[])layoutParams : null;
        if (integerArray != null) {
            layoutParams = integerArray;
            boolean bl6 = false;
            boolean bl7 = false;
            ViewGroup.LayoutParams $this$_init__u24lambda_u2d3 = layoutParams;
            boolean bl8 = false;
            $this$_init__u24lambda_u2d3.width = -1;
            $this$_init__u24lambda_u2d3.height = context.getResources().getDimensionPixelSize(R.dimen.text_wheel_picker_item_height);
            $this$_init__u24lambda_u2d3.gravity = 16;
        }
        super.refreshWeekdays();
        this.weekdayPickerView.setWheelListener((BaseWheelPickerView.WheelPickerViewListener)this);
        this.hourPickerView.setWheelListener((BaseWheelPickerView.WheelPickerViewListener)this);
        this.minutePickerView.setWheelListener((BaseWheelPickerView.WheelPickerViewListener)this);
    }

    public /* synthetic */ WeekdayTimePickerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getWeekday() {
        Integer n = (Integer)CollectionsKt.getOrNull(this.weekdays, (int)this.weekdayPickerView.getSelectedIndex());
        return n == null ? this.getFirstDayOfWeek() : n.intValue();
    }

    public final void setWeekday(int value) {
        this.weekdayPickerView.setSelectedIndex(this.weekdays.indexOf(value));
    }

    public final int getHour() {
        return this.hourPickerView.getSelectedIndex();
    }

    public final void setHour(int value) {
        this.hourPickerView.setSelectedIndex(value);
    }

    public final int getMinute() {
        return this.minutePickerView.getSelectedIndex();
    }

    public final void setMinute(int value) {
        this.minutePickerView.setSelectedIndex(value);
    }

    public final int getFirstDayOfWeek() {
        return this.calendar.getFirstDayOfWeek();
    }

    public final void setFirstDayOfWeek(int value) {
        this.calendar.setFirstDayOfWeek(value);
        this.refreshWeekdays();
    }

    public final boolean isCircular() {
        return this.isCircular;
    }

    public final void setCircular(boolean value) {
        this.isCircular = value;
        this.weekdayPickerView.setCircular(value);
        this.hourPickerView.setCircular(value);
        this.minutePickerView.setCircular(value);
    }

    public void setHapticFeedbackEnabled(boolean hapticFeedbackEnabled) {
        super.setHapticFeedbackEnabled(hapticFeedbackEnabled);
        this.weekdayPickerView.setHapticFeedbackEnabled(hapticFeedbackEnabled);
        this.hourPickerView.setHapticFeedbackEnabled(hapticFeedbackEnabled);
        this.minutePickerView.setHapticFeedbackEnabled(hapticFeedbackEnabled);
    }

    public final void setWheelListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listener = listener2;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshWeekdays() {
        Collection<TextWheelPickerView.Item> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Collection collection2 = this.normalWeekdays;
        boolean bl = false;
        this.weekdays = CollectionsKt.plus((Collection)this.normalWeekdays.subList(this.normalWeekdays.indexOf(this.calendar.getFirstDayOfWeek()), collection2.size()), (Iterable)this.normalWeekdays.subList(0, this.normalWeekdays.indexOf(this.calendar.getFirstDayOfWeek())));
        Date now = new Date();
        this.calendar.setTime(now);
        Iterable iterable = this.weekdays;
        boolean bl2 = false;
        iterable = (Iterable)RangesKt.until((int)0, (int)iterable.size());
        TextWheelAdapter textWheelAdapter = this.weekdayAdapter;
        boolean $i$f$mapIndexed = false;
        void var4_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        Iterator iterator = $this$mapIndexedTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void weekday;
            void index;
            int item$iv$iv = ((IntIterator)iterator).nextInt();
            int n = index$iv$iv++;
            boolean bl3 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = item$iv$iv;
            int n3 = n;
            collection = destination$iv$iv;
            boolean bl4 = false;
            this.calendar.set(7, ((Number)this.weekdays.get((int)index)).intValue());
            String string2 = String.valueOf((int)weekday);
            String string3 = this.formatter.format(this.calendar.getTime());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"formatter.format(calendar.time)");
            TextWheelPickerView.Item item = new TextWheelPickerView.Item(string2, string3, false, 4, null);
            collection.add(item);
        }
        collection = (List)destination$iv$iv;
        textWheelAdapter.setValues(collection);
    }

    @Override
    public void didSelectItem(@NotNull BaseWheelPickerView picker, int index) {
        Intrinsics.checkNotNullParameter((Object)picker, (String)"picker");
        Listener listener2 = this.listener;
        if (listener2 != null) {
            listener2.didSelectData(this.getWeekday(), this.getHour(), this.getMinute());
        }
    }

    @Override
    public void onScrollStateChanged(int state) {
        BaseWheelPickerView.WheelPickerViewListener.DefaultImpls.onScrollStateChanged(this, state);
    }

    @JvmOverloads
    public WeekdayTimePickerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public WeekdayTimePickerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lsh/tyy/wheelpicker/WeekdayTimePickerView$Listener;", "", "didSelectData", "", "weekday", "", "hour", "minute", "WheelPicker_release"})
    public static interface Listener {
        public void didSelectData(int var1, int var2, int var3);
    }
}

