/*
 * Decompiled with CFR 0.152.
 */
package sh.tyy.wheelpicker.core;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.tyy.wheelpicker.core.OffsetItemDecoration;
import sh.tyy.wheelpicker.core.WheelSnapHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001;B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0018\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0016J(\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0014J\u0006\u0010.\u001a\u00020$J\"\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u00072\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020$\u0018\u000102H\u0002J(\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020$\u0018\u000102J\u0010\u00103\u001a\u00020$2\u0006\u00100\u001a\u00020\u0007H\u0016J\u0016\u00104\u001a\u00020$2\f\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u000106H\u0016J\u000e\u00107\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u0015J\"\u00108\u001a\u00020$2\u0006\u00100\u001a\u00020\u00072\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020$\u0018\u000102H\u0002J(\u00108\u001a\u00020$2\u0006\u00100\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020$\u0018\u000102J\u0010\u00109\u001a\u00020$2\u0006\u00100\u001a\u00020\u0007H\u0016J\b\u0010:\u001a\u00020\u0007H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lsh/tyy/wheelpicker/core/WheelPickerRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "camera", "Landroid/graphics/Camera;", "value", "currentPosition", "getCurrentPosition", "()I", "setCurrentPosition", "(I)V", "hapticFeedbackLastTriggerPosition", "ignoreHapticFeedback", "", "listener", "Lsh/tyy/wheelpicker/core/WheelPickerRecyclerView$WheelPickerRecyclerViewListener;", "scrollToCenterPositionListener", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "snapHelper", "Lsh/tyy/wheelpicker/core/WheelSnapHelper;", "wheelMatrix", "Landroid/graphics/Matrix;", "drawChild", "canvas", "Landroid/graphics/Canvas;", "child", "Landroid/view/View;", "drawingTime", "", "onScrollStateChanged", "", "state", "onScrolled", "dx", "dy", "onSizeChanged", "w", "h", "oldw", "oldh", "refreshCurrentPosition", "scrollToCenterPosition", "position", "completion", "Lkotlin/Function0;", "scrollToPosition", "setAdapter", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "setWheelListener", "smoothScrollToCenterPosition", "smoothScrollToPosition", "visibleCenterItemPosition", "WheelPickerRecyclerViewListener", "WheelPicker_release"})
public final class WheelPickerRecyclerView
extends RecyclerView {
    @Nullable
    private WheelPickerRecyclerViewListener listener;
    @NotNull
    private final Camera camera;
    @NotNull
    private final Matrix wheelMatrix;
    @NotNull
    private final WheelSnapHelper snapHelper;
    private int hapticFeedbackLastTriggerPosition;
    private boolean ignoreHapticFeedback;
    private int currentPosition;
    @Nullable
    private ViewTreeObserver.OnGlobalLayoutListener scrollToCenterPositionListener;

    @JvmOverloads
    public WheelPickerRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        SimpleItemAnimator simpleItemAnimator;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.camera = new Camera();
        this.wheelMatrix = new Matrix();
        this.snapHelper = new WheelSnapHelper();
        this.currentPosition = -1;
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, 1, false);
        linearLayoutManager.setStackFromEnd(true);
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 1, false));
        this.snapHelper.attachToRecyclerView(this);
        this.setOverScrollMode(2);
        this.setHasFixedSize(true);
        this.addItemDecoration(new OffsetItemDecoration());
        RecyclerView.ItemAnimator itemAnimator = this.getItemAnimator();
        SimpleItemAnimator simpleItemAnimator2 = simpleItemAnimator = itemAnimator instanceof SimpleItemAnimator ? (SimpleItemAnimator)itemAnimator : null;
        if (simpleItemAnimator != null) {
            simpleItemAnimator.setSupportsChangeAnimations(false);
        }
    }

    public /* synthetic */ WheelPickerRecyclerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setWheelListener(@NotNull WheelPickerRecyclerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listener = listener2;
    }

    public final int getCurrentPosition() {
        return this.currentPosition;
    }

    private final void setCurrentPosition(int value) {
        WheelPickerRecyclerViewListener wheelPickerRecyclerViewListener;
        if (this.currentPosition == value) {
            return;
        }
        this.currentPosition = value;
        if (this.getScrollState() == 0 && (wheelPickerRecyclerViewListener = this.listener) != null) {
            wheelPickerRecyclerViewListener.didSelectItem(value);
        }
    }

    public void setAdapter(@Nullable RecyclerView.Adapter<?> adapter) {
        super.setAdapter(adapter);
        RecyclerView.Adapter<?> adapter2 = adapter;
        if (adapter2 != null) {
            adapter2.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(this){
                final /* synthetic */ WheelPickerRecyclerView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onChanged() {
                    this.this$0.refreshCurrentPosition();
                }
            });
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.invalidateItemDecorations();
    }

    public void scrollToPosition(int position) {
        WheelPickerRecyclerView.scrollToCenterPosition$default(this, position, null, 2, null);
    }

    public void smoothScrollToPosition(int position) {
        WheelPickerRecyclerView.smoothScrollToCenterPosition$default(this, position, null, 2, null);
    }

    private final void smoothScrollToCenterPosition(int position, Function0<Unit> completion2) {
        RecyclerView.OnScrollListener listener2 = new RecyclerView.OnScrollListener(this, completion2){
            final /* synthetic */ WheelPickerRecyclerView this$0;
            final /* synthetic */ Function0<Unit> $completion;
            {
                this.this$0 = $receiver;
                this.$completion = $completion;
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView2, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView2, (String)"recyclerView");
                if (newState != 0) {
                    return;
                }
                recyclerView2.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                this.this$0.refreshCurrentPosition();
                Function0<Unit> function0 = this.$completion;
                if (function0 != null) {
                    function0.invoke();
                }
            }
        };
        super.smoothScrollToPosition(position);
        this.post(() -> WheelPickerRecyclerView.smoothScrollToCenterPosition$lambda-0(this, position, listener2, completion2));
    }

    static /* synthetic */ void smoothScrollToCenterPosition$default(WheelPickerRecyclerView wheelPickerRecyclerView, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function0 = null;
        }
        wheelPickerRecyclerView.smoothScrollToCenterPosition(n, (Function0<Unit>)function0);
    }

    public final void smoothScrollToCenterPosition(int position, boolean ignoreHapticFeedback, @Nullable Function0<Unit> completion2) {
        if (ignoreHapticFeedback && this.isHapticFeedbackEnabled()) {
            this.ignoreHapticFeedback = true;
            this.smoothScrollToCenterPosition(position, (Function0<Unit>)((Function0)new Function0<Unit>(this, completion2){
                final /* synthetic */ WheelPickerRecyclerView this$0;
                final /* synthetic */ Function0<Unit> $completion;
                {
                    this.this$0 = $receiver;
                    this.$completion = $completion;
                    super(0);
                }

                public final void invoke() {
                    WheelPickerRecyclerView.access$setIgnoreHapticFeedback$p(this.this$0, false);
                    Function0<Unit> function0 = this.$completion;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }));
        } else {
            this.smoothScrollToCenterPosition(position, completion2);
        }
    }

    public static /* synthetic */ void smoothScrollToCenterPosition$default(WheelPickerRecyclerView wheelPickerRecyclerView, int n, boolean bl, Function0 function0, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function0 = null;
        }
        wheelPickerRecyclerView.smoothScrollToCenterPosition(n, bl, (Function0<Unit>)function0);
    }

    private final void scrollToCenterPosition(int position, Function0<Unit> completion2) {
        this.getViewTreeObserver().removeOnGlobalLayoutListener(this.scrollToCenterPositionListener);
        this.scrollToCenterPositionListener = new ViewTreeObserver.OnGlobalLayoutListener(this, position, completion2){
            final /* synthetic */ WheelPickerRecyclerView this$0;
            final /* synthetic */ int $position;
            final /* synthetic */ Function0<Unit> $completion;
            {
                this.this$0 = $receiver;
                this.$position = $position;
                this.$completion = $completion;
            }

            public void onGlobalLayout() {
                RecyclerView.LayoutManager layoutManager;
                RecyclerView.LayoutManager layoutManager2;
                Object object;
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                RecyclerView.LayoutManager layoutManager3 = this.this$0.getLayoutManager();
                if (layoutManager3 != null && (object = (layoutManager2 = (layoutManager = layoutManager3)).findViewByPosition(this.$position)) != null) {
                    Object snapDistance;
                    RecyclerView.LayoutManager view = layoutManager3 = object;
                    int[] nArray = WheelPickerRecyclerView.access$getSnapHelper$p(this.this$0).calculateDistanceToFinalSnap(layoutManager2, (View)view);
                    if (nArray != null && ((snapDistance = (object = (Object)nArray))[0] != false || snapDistance[1] != false)) {
                        this.this$0.scrollBy((int)snapDistance[0], (int)snapDistance[1]);
                    }
                }
                this.this$0.refreshCurrentPosition();
                Function0<Unit> function0 = this.$completion;
                if (function0 != null) {
                    function0.invoke();
                }
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.scrollToCenterPositionListener);
        super.scrollToPosition(position);
    }

    static /* synthetic */ void scrollToCenterPosition$default(WheelPickerRecyclerView wheelPickerRecyclerView, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function0 = null;
        }
        wheelPickerRecyclerView.scrollToCenterPosition(n, (Function0<Unit>)function0);
    }

    public final void scrollToCenterPosition(int position, boolean ignoreHapticFeedback, @Nullable Function0<Unit> completion2) {
        if (ignoreHapticFeedback && this.isHapticFeedbackEnabled()) {
            this.ignoreHapticFeedback = true;
            this.scrollToCenterPosition(position, (Function0<Unit>)((Function0)new Function0<Unit>(this, completion2){
                final /* synthetic */ WheelPickerRecyclerView this$0;
                final /* synthetic */ Function0<Unit> $completion;
                {
                    this.this$0 = $receiver;
                    this.$completion = $completion;
                    super(0);
                }

                public final void invoke() {
                    WheelPickerRecyclerView.access$setIgnoreHapticFeedback$p(this.this$0, false);
                    Function0<Unit> function0 = this.$completion;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }));
        } else {
            this.scrollToCenterPosition(position, completion2);
        }
    }

    public static /* synthetic */ void scrollToCenterPosition$default(WheelPickerRecyclerView wheelPickerRecyclerView, int n, boolean bl, Function0 function0, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function0 = null;
        }
        wheelPickerRecyclerView.scrollToCenterPosition(n, bl, (Function0<Unit>)function0);
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        int visibleCenterItemPosition = this.visibleCenterItemPosition();
        if (visibleCenterItemPosition == -1) {
            return;
        }
        if (this.currentPosition == -1) {
            this.setCurrentPosition(visibleCenterItemPosition);
        }
        if (this.hapticFeedbackLastTriggerPosition != visibleCenterItemPosition) {
            this.hapticFeedbackLastTriggerPosition = visibleCenterItemPosition;
            if (this.isHapticFeedbackEnabled() && !this.ignoreHapticFeedback) {
                this.performHapticFeedback(3, 2);
            }
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0) {
            this.setCurrentPosition(this.visibleCenterItemPosition());
        }
    }

    public final void refreshCurrentPosition() {
        this.setCurrentPosition(this.visibleCenterItemPosition());
    }

    private final int visibleCenterItemPosition() {
        int lastIndex;
        LinearLayoutManager linearLayoutManager;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
        if (linearLayoutManager == null) {
            return -1;
        }
        LinearLayoutManager linearLayoutManager3 = linearLayoutManager;
        int firstIndex = linearLayoutManager3.findFirstVisibleItemPosition();
        int n = firstIndex;
        if (n <= (lastIndex = linearLayoutManager3.findLastVisibleItemPosition())) {
            int i;
            do {
                RecyclerView.ViewHolder viewHolder;
                RecyclerView.ViewHolder viewHolder2;
                if ((viewHolder2 = this.findViewHolderForAdapterPosition(i = n++)) == null) continue;
                RecyclerView.ViewHolder holder = viewHolder = viewHolder2;
                viewHolder2 = holder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)viewHolder2, (String)"holder.itemView");
                RecyclerView.ViewHolder child = viewHolder2;
                int centerY = this.getHeight() / 2;
                if (child.getTop() > centerY || child.getBottom() < centerY) continue;
                return i;
            } while (i != lastIndex);
        }
        return -1;
    }

    public boolean drawChild(@Nullable Canvas canvas, @Nullable View child, long drawingTime) {
        if (canvas == null || child == null) {
            return super.drawChild(canvas, child, drawingTime);
        }
        int centerY = (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        float childCenterY = (float)child.getTop() + (float)child.getHeight() / 2.0f;
        float factor = ((float)centerY - childCenterY) * 1.0f / (float)centerY;
        boolean bl = false;
        float alphaFactor = 1.0f - 0.7f * Math.abs(factor);
        child.setAlpha(alphaFactor * alphaFactor * alphaFactor);
        boolean bl2 = false;
        float scaleFactor = 1.0f - 0.3f * Math.abs(factor);
        child.setScaleX(scaleFactor);
        child.setScaleY(scaleFactor);
        float rotateRadius = (float)((double)(2.0f * (float)centerY) / Math.PI);
        float rad = ((float)centerY - childCenterY) * 1.0f / rotateRadius;
        boolean bl3 = false;
        float offsetY = (float)centerY - childCenterY - rotateRadius * (float)Math.sin(rad) * 1.3f;
        child.setTranslationY(offsetY);
        canvas.save();
        this.camera.save();
        bl3 = false;
        this.camera.translate(0.0f, 0.0f, rotateRadius * (1.0f - (float)Math.cos(rad)));
        this.camera.rotateX(rad * (float)180 / (float)Math.PI);
        this.camera.getMatrix(this.wheelMatrix);
        this.camera.restore();
        this.wheelMatrix.preTranslate((float)(-child.getWidth()) / 2.0f, -childCenterY);
        this.wheelMatrix.postTranslate((float)child.getWidth() / 2.0f, childCenterY);
        canvas.concat(this.wheelMatrix);
        boolean result = super.drawChild(canvas, child, drawingTime);
        canvas.restore();
        return result;
    }

    @JvmOverloads
    public WheelPickerRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public WheelPickerRecyclerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void smoothScrollToCenterPosition$lambda-0(WheelPickerRecyclerView this$0, int $position, RecyclerView.OnScrollListener $listener, Function0 $completion) {
        RecyclerView.LayoutManager view;
        int[] nArray;
        RecyclerView.LayoutManager layoutManager;
        RecyclerView.LayoutManager layoutManager2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        RecyclerView.LayoutManager layoutManager3 = this$0.getLayoutManager();
        if (layoutManager3 != null && (object = (layoutManager2 = (layoutManager = layoutManager3)).findViewByPosition($position)) != null && (nArray = this$0.snapHelper.calculateDistanceToFinalSnap(layoutManager2, (View)(view = (layoutManager3 = object)))) != null) {
            object = nArray;
            Object snapDistance = object;
            if (snapDistance[0] != false || snapDistance[1] != false) {
                this$0.addOnScrollListener($listener);
                this$0.smoothScrollBy((int)snapDistance[0], (int)snapDistance[1]);
                return;
            }
            object = $completion;
            if (object != null) {
                object.invoke();
            }
        }
    }

    public static final /* synthetic */ void access$setIgnoreHapticFeedback$p(WheelPickerRecyclerView $this, boolean bl) {
        $this.ignoreHapticFeedback = bl;
    }

    public static final /* synthetic */ WheelSnapHelper access$getSnapHelper$p(WheelPickerRecyclerView $this) {
        return $this.snapHelper;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lsh/tyy/wheelpicker/core/WheelPickerRecyclerView$WheelPickerRecyclerViewListener;", "", "didSelectItem", "", "position", "", "WheelPicker_release"})
    public static interface WheelPickerRecyclerViewListener {
        public void didSelectItem(int var1);
    }
}

