/*
 * Decompiled with CFR 0.152.
 */
package si.uom;

import java.util.Set;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import si.uom.quantity.IonizingRadiation;
import tec.units.ri.AbstractConverter;
import tec.units.ri.AbstractSystemOfUnits;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.SimpleUnitFormat;
import tec.units.ri.function.LogConverter;
import tec.units.ri.function.MultiplyConverter;
import tec.units.ri.function.PiMultiplierConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.unit.TransformedUnit;
import tec.units.ri.unit.Units;

public class NonSI
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Non-SI Units";
    private static final int STANDARD_GRAVITY_DIVIDEND = 980665;
    private static final int STANDARD_GRAVITY_DIVISOR = 100000;
    static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final double AVOGADRO_CONSTANT = 6.02214199E23;
    private static final double ELEMENTARY_CHARGE = 1.602176462E-19;
    private static final NonSI INSTANCE = new NonSI();
    public static final Unit<Angle> DEGREE_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1.0, 180.0))), "Degree Angle", "deg");
    public static final Unit<Angle> MINUTE_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1.0, 10800.0))), "Minute Angle", "'");
    public static final Unit<Angle> SECOND_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1.0, 648000.0))), "Second Angle", "''");
    public static final Unit<Mass> TONNE = NonSI.addUnit(new TransformedUnit(Units.KILOGRAM, (UnitConverter)new RationalConverter(1000.0, 1.0)), "Tonne", "t");
    public static final Unit<Energy> ELECTRON_VOLT = NonSI.addUnit(new TransformedUnit(Units.JOULE, (UnitConverter)new MultiplyConverter(1.602176487E-19)), "Electron Volt", "eV");
    public static final Unit<Mass> UNIFIED_ATOMIC_MASS = NonSI.addUnit(new TransformedUnit(Units.KILOGRAM, (UnitConverter)new MultiplyConverter(1.660538782E-27)), "Unified atomic mass", "u", true);
    public static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.addUnit(new TransformedUnit(Units.METRE, (UnitConverter)new MultiplyConverter(1.49597871E11)), "Astronomical Unit", "UA");
    public static final Unit<Area> HECTARE = NonSI.addUnit(new TransformedUnit(Units.SQUARE_METRE, (UnitConverter)new RationalConverter(10000.0, 1.0)), "Hectare", "ha");
    static final Unit<Dimensionless> PI = NonSI.addUnit(AbstractUnit.ONE.multiply(Math.PI));
    static final Unit<Dimensionless> DECIBEL = AbstractUnit.ONE.transform((UnitConverter)new LogConverter(10.0).inverse().concatenate((AbstractConverter)new RationalConverter(1.0, 10.0)));
    static final Unit<AmountOfSubstance> ATOM = Units.MOLE.divide(6.02214199E23);
    public static final Unit<Length> ANGSTROM = NonSI.addUnit(Units.METRE.divide(1.0E10), "\u00c5ngstr\u00f6m", "\u00c5");
    static final Unit<Length> LIGHT_YEAR = NonSI.addUnit(Units.METRE.multiply(9.460528405E15));
    static final Unit<Length> PARSEC = Units.METRE.multiply(3.085677E16);
    static final Unit<Time> DAY_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(86164.09));
    static final Unit<Time> YEAR_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(3.155814954E7));
    static final Unit<Time> YEAR_JULIEN = NonSI.addUnit(Units.SECOND.multiply(3.15576E7));
    static final Unit<Mass> ATOMIC_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(1.6605387280149467E-27));
    static final Unit<Mass> ELECTRON_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(9.10938188E-31));
    static final Unit<ElectricCharge> E = NonSI.addUnit(Units.COULOMB.multiply(1.602176462E-19));
    static final Unit<ElectricCharge> FARADAY = NonSI.addUnit(Units.COULOMB.multiply(96485.3414719984));
    static final Unit<ElectricCharge> FRANKLIN = NonSI.addUnit(Units.COULOMB.multiply(3.3356E-10));
    static final Unit<Temperature> RANKINE = Units.KELVIN.multiply(5.0).divide(9.0);
    static final Unit<Angle> REVOLUTION = NonSI.addUnit(Units.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class));
    static final Unit<Speed> C = Units.METRE_PER_SECOND.multiply(2.99792458E8);
    static final Unit<Acceleration> G = Units.METRE_PER_SQUARE_SECOND.multiply(980665.0).divide(100000.0);
    public static final Unit<ElectricCurrent> GILBERT = Units.AMPERE.multiply(10.0).divide(4.0).multiply(PI).asType(ElectricCurrent.class);
    public static final Unit<Energy> ERG = Units.JOULE.divide(1.0E7);
    static final Unit<Illuminance> LAMBERT = NonSI.addUnit(Units.LUX.multiply(10000.0));
    static final Unit<MagneticFlux> MAXWELL = NonSI.addUnit(Units.WEBER.divide(1.0E8));
    static final Unit<MagneticFluxDensity> GAUSS = NonSI.addUnit(Units.TESLA.divide(10000.0));
    static final Unit<Force> DYNE = NonSI.addUnit(Units.NEWTON.divide(100000.0));
    static final Unit<Force> KILOGRAM_FORCE = Units.NEWTON.multiply(980665.0).divide(100000.0);
    static final Unit<Force> POUND_FORCE = Units.NEWTON.multiply(4.4482216152605E13).divide(1.0E13);
    static final Unit<Pressure> ATMOSPHERE = NonSI.addUnit(Units.PASCAL.multiply(101325.0));
    public static final Unit<Pressure> BAR = NonSI.addUnit(Units.PASCAL.multiply(100000.0), "Bar", "b");
    public static final Unit<Pressure> MILLIMETRE_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(133.322));
    static final Unit<Pressure> INCH_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(3386.388));
    public static final Unit<RadiationDoseAbsorbed> RAD = NonSI.addUnit(Units.GRAY.divide(100.0), "Rad", "rd");
    static final Unit<RadiationDoseEffective> REM = NonSI.addUnit(Units.SIEVERT.divide(100.0));
    static final Unit<Radioactivity> CURIE = NonSI.addUnit(Units.BECQUEREL.multiply(3.7E10));
    static final Unit<Radioactivity> RUTHERFORD = NonSI.addUnit(Units.BECQUEREL.multiply(1000000.0));
    static final Unit<SolidAngle> SPHERE = NonSI.addUnit(Units.STERADIAN.multiply(4.0).multiply(PI).asType(SolidAngle.class));
    static final Unit<Frequency> FRAMES_PER_SECOND = NonSI.addUnit(AbstractUnit.ONE.divide(Units.SECOND)).asType(Frequency.class);
    public static final Unit<IonizingRadiation> ROENTGEN = NonSI.addUnit(Units.COULOMB.divide(Units.KILOGRAM).multiply(2.58E-4), "Roentgen", "r", true);

    private NonSI() {
    }

    public static NonSI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel && text != null) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)NonSI.INSTANCE.units, unit, (String)name);
        }
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return NonSI.addUnit(unit, name, text, true);
    }
}

