/*
 * Decompiled with CFR 0.152.
 */
package si.urbas.pless.db;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import play.core.enhancers.PropertiesEnhancer;
import si.urbas.pless.db.PlayJpaTransactions;
import si.urbas.pless.db.TransactionCallback;
import si.urbas.pless.db.TransactionFunction;
import si.urbas.pless.util.ConfigurationSource;
import si.urbas.pless.util.Factory;
import si.urbas.pless.util.SingletonFactory;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class JpaTransactions {
    public static final String CONFIG_JPA_TRANSACTIONS = "pless.jpaTransactions";

    public static JpaTransactions getJpaTransactions() {
        return (JpaTransactions)JpaTransactionsFactory.INSTANCE.createInstance(ConfigurationSource.getConfigurationSource());
    }

    public void withTransaction(final TransactionCallback callback) {
        this.withTransaction(new TransactionFunction<Void>(){

            public Void invoke(EntityManager entityManager) {
                callback.invoke(entityManager);
                return null;
            }
        });
    }

    public <T> T withTransaction(TransactionFunction<T> transactionFunction) {
        EntityManager entityManager = null;
        EntityTransaction tx = null;
        try {
            entityManager = this.getEntityManager();
            tx = this.beginTransaction(entityManager);
            Object result = transactionFunction.invoke(entityManager);
            this.commitTransaction(tx);
            Object object = result;
            return (T)object;
        }
        catch (Exception ex) {
            this.rollbackTransaction(tx);
            throw ex;
        }
        finally {
            this.closeEntityManager(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T usingDb(TransactionFunction<T> databaseQueryFunction) {
        EntityManager entityManager = null;
        try {
            entityManager = this.getEntityManager();
            Object object = databaseQueryFunction.invoke(entityManager);
            return (T)object;
        }
        finally {
            this.closeEntityManager(entityManager);
        }
    }

    public abstract EntityManager getEntityManager();

    public abstract void closeEntityManager(EntityManager var1);

    private void commitTransaction(EntityTransaction tx) {
        if (tx.getRollbackOnly()) {
            tx.rollback();
        } else {
            tx.commit();
        }
    }

    private EntityTransaction beginTransaction(EntityManager em) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        return tx;
    }

    private void rollbackTransaction(EntityTransaction tx) {
        try {
            tx.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class DefaultJpaTransactionsFactory
    implements Factory<JpaTransactions> {
        private DefaultJpaTransactionsFactory() {
        }

        public JpaTransactions createInstance(ConfigurationSource configurationSource) {
            return new PlayJpaTransactions();
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static class JpaTransactionsFactory {
        public static final Factory<JpaTransactions> INSTANCE = new SingletonFactory("pless.jpaTransactions", (Factory)new DefaultJpaTransactionsFactory());

        JpaTransactionsFactory() {
        }
    }
}

