/*
 * Decompiled with CFR 0.152.
 */
package si.urbas.pless.sessions;

import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import play.core.enhancers.PropertiesEnhancer;

@Entity(name="Session")
@NamedQueries(value={@NamedQuery(name="JpaServerSessionKeyValue.deleteByKey", query="DELETE FROM Session s WHERE s.key = :key")})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JpaServerSessionKeyValue {
    public static final String QUERY_DELETE_BY_KEY = "JpaServerSessionKeyValue.deleteByKey";
    @Id
    private String key;
    private String value;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Calendar expirationStart;
    @Column(nullable=false)
    private int expirationDuration;

    public JpaServerSessionKeyValue() {
    }

    public JpaServerSessionKeyValue(String key, String value, int expirationDuration) {
        this.key = key;
        this.value = value;
        this.expirationDuration = expirationDuration;
        this.expirationStart = Calendar.getInstance();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isExpired() {
        long expirationTimeInMillis;
        long currentTimeInMillis = Calendar.getInstance().getTimeInMillis();
        return currentTimeInMillis > (expirationTimeInMillis = this.expirationStart.getTimeInMillis() + (long)this.expirationDuration);
    }
}

