/*
 * Decompiled with CFR 0.152.
 */
package si.urbas.pless.sessions;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import play.core.enhancers.PropertiesEnhancer;
import si.urbas.pless.db.JpaTransactions;
import si.urbas.pless.db.TransactionCallback;
import si.urbas.pless.db.TransactionFunction;
import si.urbas.pless.sessions.JpaServerSessionKeyValue;
import si.urbas.pless.sessions.ServerSessionStorage;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JpaServerSessionStorage
extends ServerSessionStorage {
    public void put(final String key, final String value, final int expirationMillis) {
        JpaTransactions.getJpaTransactions().withTransaction(new TransactionCallback(){

            public void invoke(EntityManager entityManager) {
                JpaServerSessionKeyValue jpaServerSessionKeyValue = new JpaServerSessionKeyValue(key, value, expirationMillis);
                entityManager.persist((Object)jpaServerSessionKeyValue);
            }
        });
    }

    public String get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        JpaServerSessionKeyValue sessionValue = this.fetchSessionValue(key);
        if (sessionValue == null) {
            return null;
        }
        if (sessionValue.isExpired()) {
            this.removeSessionValue(key);
            return null;
        }
        return sessionValue.getValue();
    }

    public void remove(String key) {
        this.removeSessionValue(key);
    }

    private JpaServerSessionKeyValue fetchSessionValue(final String key) {
        return JpaTransactions.getJpaTransactions().usingDb(new TransactionFunction<JpaServerSessionKeyValue>(){

            public JpaServerSessionKeyValue invoke(EntityManager entityManager) {
                return (JpaServerSessionKeyValue)entityManager.find(JpaServerSessionKeyValue.class, (Object)key);
            }
        });
    }

    private boolean removeSessionValue(final String key) {
        return JpaTransactions.getJpaTransactions().withTransaction(new TransactionFunction<Boolean>(){

            public Boolean invoke(EntityManager entityManager) {
                Query deleteSessionKeyQuery = entityManager.createNamedQuery("JpaServerSessionKeyValue.deleteByKey");
                deleteSessionKeyQuery.setParameter("key", (Object)key);
                int deletedRows = deleteSessionKeyQuery.executeUpdate();
                return deletedRows > 0;
            }
        });
    }
}

