/*
 * Decompiled with CFR 0.152.
 */
package si.urbas.pless.users;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import play.core.enhancers.PropertiesEnhancer;
import si.urbas.pless.authentication.SaltedHashedPassword;
import si.urbas.pless.users.PlessUser;
import si.urbas.pless.util.Hashes;

@Entity(name="PlessUser")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@NamedQueries(value={@NamedQuery(name="PlessUser.getByEmail", query="SELECT u FROM PlessUser u WHERE u.email = :email"), @NamedQuery(name="PlessUser.activate", query="UPDATE PlessUser u SET u.activated = TRUE WHERE u.email = :email AND u.activationCode = :activationCode"), @NamedQuery(name="PlessUser.delete", query="DELETE FROM PlessUser u WHERE u.email = :email"), @NamedQuery(name="PlessUser.getAll", query="SELECT u FROM PlessUser u")})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JpaPlessUser
extends PlessUser {
    public static final String QUERY_GET_BY_EMAIL = "PlessUser.getByEmail";
    public static final String QUERY_GET_ALL = "PlessUser.getAll";
    public static final String QUERY_ACTIVATE_USER = "PlessUser.activate";
    public static final String QUERY_DELETE_USER = "PlessUser.delete";

    public JpaPlessUser() {
    }

    public JpaPlessUser(String email, String username, SaltedHashedPassword password) {
        this(email, username, password.getHashedPassword(), password.getSalt());
    }

    public JpaPlessUser(String email, String username, byte[] hashedPassword, byte[] salt) {
        super(0L, email, username, hashedPassword, salt, null, false, Hashes.urlSafeHash());
    }

    public JpaPlessUser(long id) {
        super(id);
    }

    public JpaPlessUser(String email, String username, String password) {
        this(email, username, new SaltedHashedPassword(password));
    }

    public JpaPlessUser withId(long idOfNewUser) {
        JpaPlessUser user = new JpaPlessUser(this.getEmail(), this.getUsername(), this.getHashedPassword(), this.getSalt());
        user.id = idOfNewUser;
        return user;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    @Id
    @GeneratedValue
    public long getId() {
        return super.getId();
    }

    @Column(nullable=false, unique=true)
    public String getEmail() {
        return super.getEmail();
    }

    @Column(nullable=true, unique=true)
    public String getUsername() {
        return super.getUsername();
    }

    @Column(nullable=false)
    public byte[] getHashedPassword() {
        return super.getHashedPassword();
    }

    @Column(nullable=false)
    public byte[] getSalt() {
        return super.getSalt();
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creationTimestamp", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", insertable=false, updatable=false)
    public Date getCreationDate() {
        return super.getCreationDate();
    }

    @Column(nullable=false)
    public boolean isActivated() {
        return super.isActivated();
    }

    @Column(nullable=false)
    public String getActivationCode() {
        return super.getActivationCode();
    }

    @Column
    public String getPasswordResetCode() {
        return super.getPasswordResetCode();
    }

    @Column
    public Date getPasswordResetTimestamp() {
        return super.getPasswordResetTimestamp();
    }
}

