/*
 * Decompiled with CFR 0.152.
 */
package si.urbas.pless.users;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import play.core.enhancers.PropertiesEnhancer;
import si.urbas.pless.db.JpaTransactions;
import si.urbas.pless.db.TransactionCallback;
import si.urbas.pless.db.TransactionFunction;
import si.urbas.pless.users.JpaPlessUser;
import si.urbas.pless.users.PlessUser;
import si.urbas.pless.users.UserRepository;
import si.urbas.pless.util.ConfigurationSource;
import si.urbas.pless.util.Factory;
import si.urbas.pless.util.StringUtils;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JpaUserRepository
extends UserRepository
implements Factory<UserRepository> {
    public PlessUser findUserByEmail(final String email) {
        return JpaTransactions.getJpaTransactions().usingDb(new TransactionFunction<PlessUser>(){

            public PlessUser invoke(EntityManager entityManager) {
                TypedQuery usersByEmailQuery = entityManager.createNamedQuery("PlessUser.getByEmail", JpaPlessUser.class);
                usersByEmailQuery.setParameter("email", (Object)email);
                return (PlessUser)usersByEmailQuery.getSingleResult();
            }
        });
    }

    public List<PlessUser> getAllUsers() {
        return JpaTransactions.getJpaTransactions().usingDb(new TransactionFunction<List<PlessUser>>(){

            public List<PlessUser> invoke(EntityManager entityManager) {
                return entityManager.createNamedQuery("PlessUser.getAll").getResultList();
            }
        });
    }

    public void persistUser(final PlessUser user) {
        this.assertUserPreconditionsForPersist(user);
        JpaTransactions.getJpaTransactions().withTransaction(new TransactionCallback(){

            public void invoke(EntityManager entityManager) {
                String validationError = user.validateForPersist();
                if (validationError == null) {
                    entityManager.persist((Object)user);
                } else {
                    JpaUserRepository.this.throwPersistUserException("Validation error: " + validationError, user);
                }
            }
        });
    }

    public boolean activateUser(final String userEmail, final String activationCode) {
        return JpaTransactions.getJpaTransactions().withTransaction(new TransactionFunction<Boolean>(){

            public Boolean invoke(EntityManager entityManager) {
                Query usersByEmailQuery = entityManager.createNamedQuery("PlessUser.activate");
                usersByEmailQuery.setParameter("email", (Object)userEmail);
                usersByEmailQuery.setParameter("activationCode", (Object)activationCode);
                return usersByEmailQuery.executeUpdate() > 0;
            }
        });
    }

    public boolean delete(final String userEmail) {
        return JpaTransactions.getJpaTransactions().withTransaction(new TransactionFunction<Boolean>(){

            public Boolean invoke(EntityManager entityManager) {
                Query deleteUserQuery = entityManager.createNamedQuery("PlessUser.delete");
                deleteUserQuery.setParameter("email", (Object)userEmail);
                int deletedRows = deleteUserQuery.executeUpdate();
                return deletedRows > 0;
            }
        });
    }

    public PlessUser findUserById(final long userId) {
        return JpaTransactions.getJpaTransactions().usingDb(new TransactionFunction<PlessUser>(){

            public PlessUser invoke(EntityManager entityManager) {
                JpaPlessUser foundUser = (JpaPlessUser)((Object)entityManager.find(JpaPlessUser.class, (Object)userId));
                if (foundUser == null) {
                    throw new NoResultException("Could not find the user with the id " + userId);
                }
                return foundUser;
            }
        });
    }

    public void mergeUser(final PlessUser updatedUser) {
        if (updatedUser.getId() <= 0L) {
            throw new RuntimeException("Could not apply changes to the user. The user with the ID '" + updatedUser.getId() + "' was not persisted in this user repository.");
        }
        JpaTransactions.getJpaTransactions().withTransaction(new TransactionCallback(){

            public void invoke(EntityManager entityManager) {
                entityManager.merge((Object)updatedUser);
            }
        });
    }

    public PlessUser createUser(String email, String username, String password) {
        return new JpaPlessUser(email, username, password);
    }

    public UserRepository createInstance(ConfigurationSource configurationSource) {
        return new JpaUserRepository();
    }

    private void assertUserPreconditionsForPersist(PlessUser user) {
        if (StringUtils.isNullOrEmpty((String)user.getEmail())) {
            this.throwPersistUserException("User's email must not be 'null' or empty.", user);
        }
    }
}

