/*
 * Decompiled with CFR 0.152.
 */
package site.dungang.allowedparams;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AllowedParamWrapper
extends HttpServletRequestWrapper {
    protected Map<String, Boolean> allowedMap = new HashMap<String, Boolean>();

    public AllowedParamWrapper(HttpServletRequest request, String[] allowedParams) {
        super(request);
        if (null != allowedParams) {
            for (String param : allowedParams) {
                this.allowedMap.put(param, true);
            }
        }
    }

    public String getParameter(String name) {
        if (null != this.allowedMap.get(name)) {
            return super.getParameter(name);
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        Map map = super.getParameterMap();
        for (String name : map.keySet()) {
            if (null != this.allowedMap.get(name)) continue;
            map.remove(name);
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> names = new Vector<String>();
        Enumeration enumer = super.getParameterNames();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            if (null == this.allowedMap.get(name)) continue;
            names.addElement(name);
        }
        return names.elements();
    }

    public String[] getParameterValues(String name) {
        if (null == this.allowedMap.get(name)) {
            return super.getParameterValues(name);
        }
        return null;
    }
}

