/*
 * Decompiled with CFR 0.152.
 */
package site.dungang.allowedparams.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelFactory;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import site.dungang.allowedparams.AllowedParamWrapper;
import site.dungang.allowedparams.annotation.AllowedParams;

public class AllowedParamsModelAttributeMethodProcessor
implements HandlerMethodArgumentResolver,
HandlerMethodReturnValueHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean supportsReturnType(MethodParameter parameter) {
        boolean isSupported = parameter.hasParameterAnnotation(AllowedParams.class);
        this.logger.debug("\u68c0\u67e5\u65b9\u6cd5\u8fd4\u56de\u503c\u662f\u5426\u652f\u6301\uff1a AllowedParams \u6ce8\u89e3 : " + isSupported);
        return isSupported;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue != null) {
            String name = ModelFactory.getNameForReturnValue((Object)returnValue, (MethodParameter)returnType);
            mavContainer.addAttribute(name, returnValue);
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        boolean isSupported = parameter.hasParameterAnnotation(AllowedParams.class);
        this.logger.debug("\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570\u662f\u5426\u652f\u6301\uff1a AllowedParams \u6ce8\u89e3 : " + isSupported);
        return isSupported;
    }

    public final Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String name = ModelFactory.getNameForParameter((MethodParameter)parameter);
        Object attribute = mavContainer.containsAttribute(name) ? mavContainer.getModel().get((Object)name) : this.createAttribute(name, parameter, binderFactory, webRequest);
        WebDataBinder binder = binderFactory.createBinder(webRequest, attribute, name);
        if (binder.getTarget() != null) {
            String[] allowedParams = null;
            AllowedParams ann = (AllowedParams)parameter.getParameterAnnotation(AllowedParams.class);
            if (ann != null) {
                allowedParams = ann.params();
            }
            this.bindRequestParameters(binder, webRequest, allowedParams);
            this.validateIfApplicable(binder, parameter);
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                throw new BindException(binder.getBindingResult());
            }
        }
        Map bindingResultModel = binder.getBindingResult().getModel();
        mavContainer.removeAttributes(bindingResultModel);
        mavContainer.addAllAttributes(bindingResultModel);
        return binder.convertIfNecessary(binder.getTarget(), parameter.getParameterType(), parameter);
    }

    protected Object createAttribute(String attributeName, MethodParameter methodParam, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        String value = this.getRequestValueForAttribute(attributeName, request);
        if (value != null) {
            Object attribute = this.createAttributeFromRequestValue(value, attributeName, methodParam, binderFactory, request);
            this.logger.debug("createAttributeFromRequestValue : " + attribute.toString());
            if (attribute != null) {
                return attribute;
            }
        }
        return BeanUtils.instantiateClass((Class)methodParam.getParameterType());
    }

    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request, String[] allowedParams) {
        ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
        Object servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        if (null != allowedParams) {
            this.logger.debug("allowed params: " + Arrays.toString(allowedParams));
            servletRequest = new AllowedParamWrapper((HttpServletRequest)servletRequest, allowedParams);
        }
        servletBinder.bind((ServletRequest)servletRequest);
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter methodParam) {
        Annotation[] annotations;
        for (Annotation ann : annotations = methodParam.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            binder.validate(validationHints);
            break;
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter methodParam) {
        int i = methodParam.getParameterIndex();
        Class<?>[] paramTypes = methodParam.getMethod().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    protected String getRequestValueForAttribute(String attributeName, NativeWebRequest request) {
        Map<String, String> variables = this.getUriTemplateVariables(request);
        String variableValue = variables.get(attributeName);
        if (StringUtils.hasText((String)variableValue)) {
            return variableValue;
        }
        String parameterValue = request.getParameter(attributeName);
        if (StringUtils.hasText((String)parameterValue)) {
            return parameterValue;
        }
        return null;
    }

    protected final Map<String, String> getUriTemplateVariables(NativeWebRequest request) {
        Map<String, String> variables = (Map<String, String>)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        return variables != null ? variables : Collections.emptyMap();
    }

    protected Object createAttributeFromRequestValue(String sourceValue, String attributeName, MethodParameter methodParam, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        TypeDescriptor target;
        TypeDescriptor source;
        WebDataBinder binder = binderFactory.createBinder(request, null, attributeName);
        ConversionService conversionService = binder.getConversionService();
        if (conversionService != null && conversionService.canConvert(source = TypeDescriptor.valueOf(String.class), target = new TypeDescriptor(methodParam))) {
            return binder.convertIfNecessary((Object)sourceValue, methodParam.getParameterType(), methodParam);
        }
        return null;
    }
}

