/*
 * Decompiled with CFR 0.152.
 */
package kamons.string;

public class NameStyleUtil {
    public static String toPascal(String value) {
        return NameStyleUtil.toCamelStyle(value, true);
    }

    public static String toCamel(String value) {
        return NameStyleUtil.toCamelStyle(value, false);
    }

    public static String toUnderscore(String value) {
        char[] chars = value.toCharArray();
        char[] out = new char[chars.length * 2];
        int index = 0;
        for (char c : chars) {
            if (Character.isUpperCase(c) && index > 0) {
                out[index++] = 95;
                out[index++] = Character.toLowerCase(c);
                continue;
            }
            out[index++] = c;
        }
        if (index > 0) {
            out[0] = Character.toLowerCase(out[0]);
        }
        return new String(out, 0, index);
    }

    public static String toUpperUnderscore(String value) {
        return NameStyleUtil.toUnderscore(value).toUpperCase();
    }

    private static String toCamelStyle(String name, boolean upperFirst) {
        char[] chars = name.toCharArray();
        char[] out = new char[chars.length];
        int index = 0;
        boolean isFirst = true;
        for (char c : chars) {
            if (c == '_') {
                isFirst = true;
                continue;
            }
            out[index++] = isFirst ? Character.toUpperCase(c) : c;
            isFirst = false;
        }
        if (index > 0 && !upperFirst) {
            out[0] = Character.toLowerCase(out[0]);
        }
        return new String(out, 0, index);
    }
}

