/*
 * Decompiled with CFR 0.152.
 */
package sk.teamsoft.autobundler;

import android.os.Bundle;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sk.teamsoft.autobundler.KeepState;
import sk.teamsoft.autobundler.StateKeeper;

public final class AutoBundler {
    private static final Map<Class, StateKeeper> KEEPER_CACHE = new HashMap<Class, StateKeeper>();
    private static final Set<String> NONKEEPER_CACHE = new HashSet<String>();
    private static AutoBundler sInstance;

    public static void onRestore(Object component, Bundle savedInstanceState) {
        AutoBundler.getInstance().internalRestore(component, savedInstanceState, 2);
    }

    public static void onCreate(Object component, Bundle savedInstanceState) {
        AutoBundler.getInstance().internalRestore(component, savedInstanceState, 1);
    }

    public static void onSave(Object component, Bundle outState) {
        AutoBundler.getInstance().internalStore(component, outState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AutoBundler getInstance() {
        if (sInstance != null) return sInstance;
        Class<AutoBundler> clazz = AutoBundler.class;
        synchronized (AutoBundler.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AutoBundler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private AutoBundler() {
    }

    private void internalStore(final Object component, final Bundle outState) {
        if (outState == null) {
            return;
        }
        this.getKeeperAndCall(component, new KeeperCallback(){

            @Override
            public void call(StateKeeper keeper) {
                Log.v((String)keeper.getClass().getSimpleName(), (String)("store: " + component.getClass().getSimpleName()));
                keeper.store(component, outState);
            }
        });
    }

    private void internalRestore(final Object component, final Bundle state, final int mode) {
        if (state == null) {
            return;
        }
        this.getKeeperAndCall(component, new KeeperCallback(){

            @Override
            public void call(StateKeeper keeper) {
                Log.v((String)keeper.getClass().getSimpleName(), (String)("restore: " + component.getClass().getSimpleName() + " [mode=" + mode + "]"));
                keeper.restore(component, state, mode);
            }
        });
    }

    private void getKeeperAndCall(Object component, KeeperCallback callable) {
        if (NONKEEPER_CACHE.contains(component.getClass().getName())) {
            return;
        }
        try {
            Class<?> keeper = this.getComponentKeeper(component);
            callable.call(this.getKeeper(keeper));
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                for (Field field : component.getClass().getDeclaredFields()) {
                    if (!field.isAnnotationPresent(KeepState.class)) continue;
                    e.printStackTrace();
                    throw new IllegalStateException("AutoBundler: StateKeeper error: " + e.getMessage());
                }
                Log.v((String)"AutoBundler", (String)("component " + component.getClass().getSimpleName() + " does not have a StateKeeper. It will be cached as non-keeper class"));
                NONKEEPER_CACHE.add(component.getClass().getName());
            }
            e.printStackTrace();
            throw new IllegalStateException("AutoBundler: StateKeeper error: " + e.getMessage());
        }
    }

    private Class<?> getComponentKeeper(Object component) throws ClassNotFoundException {
        return Class.forName(component.getClass().getName() + "$$StateKeeper");
    }

    private StateKeeper getKeeper(Class<?> clz) throws IllegalAccessException, InstantiationException {
        if (KEEPER_CACHE.containsKey(clz)) {
            return KEEPER_CACHE.get(clz);
        }
        StateKeeper o = (StateKeeper)clz.newInstance();
        KEEPER_CACHE.put(clz, o);
        return o;
    }

    static interface KeeperCallback {
        public void call(StateKeeper var1);
    }
}

