/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.entry.LogEntry;
import java.nio.ByteBuffer;

public class SingleItemLogEntry
implements LogEntry {
    private Class logClass;
    LogReadable item;

    public SingleItemLogEntry(Class logClass) {
        this.logClass = logClass;
    }

    public void readEntry(ByteBuffer entryBuffer, int entrySize, byte entryTypeVersion, boolean readFullItem) throws DatabaseException {
        try {
            this.item = (LogReadable)this.logClass.newInstance();
            this.item.readFromLog(entryBuffer);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        this.item.dumpLog(sb, verbose);
        return sb;
    }

    public Object getMainItem() {
        return this.item;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isTransactional() {
        return this.item.logEntryIsTransactional();
    }

    public long getTransactionId() {
        return this.item.getTransactionId();
    }

    public LogEntry getNewInstance() throws DatabaseException {
        try {
            return (LogEntry)this.logClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
    }
}

