/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

public class BooleanBinding
extends TupleBinding {
    private static final int BOOLEAN_SIZE = 1;

    public Object entryToObject(TupleInput input) {
        return input.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void objectToEntry(Object object, TupleOutput output) {
        output.writeBoolean((Boolean)object);
    }

    protected TupleOutput getTupleOutput(Object object) {
        return BooleanBinding.sizedOutput();
    }

    public static boolean entryToBoolean(DatabaseEntry entry) {
        return BooleanBinding.entryToInput(entry).readBoolean();
    }

    public static void booleanToEntry(boolean val, DatabaseEntry entry) {
        BooleanBinding.outputToEntry(BooleanBinding.sizedOutput().writeBoolean(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[1]);
    }
}

