/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import java.io.File;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAEnvironment
extends Environment
implements XAResource {
    private static final boolean DEBUG = false;

    public XAEnvironment(File envHome, EnvironmentConfig configuration) throws DatabaseException {
        super(envHome, configuration);
    }

    public Transaction getXATransaction(Xid xid) throws DatabaseException {
        Txn ret = this.environmentImpl.getTxnManager().getTxnFromXid(xid);
        if (ret == null) {
            return null;
        }
        return new Transaction(this, ret);
    }

    public void setXATransaction(Xid xid, Transaction txn) throws DatabaseException {
        this.environmentImpl.getTxnManager().registerXATxn(xid, txn.getTxn(), false);
    }

    public void commit(Xid xid, boolean ignore) throws XAException {
        if (xid == null) {
            return;
        }
        try {
            this.checkEnv();
            Transaction txn = this.getXATransaction(xid);
            if (txn == null) {
                throw new XAException("No transaction found for " + xid + " during commit.");
            }
            this.removeReferringHandle(txn);
            if (txn.getTxn().getOnlyAbortable()) {
                throw new XAException(100);
            }
            txn.getTxn().commit(xid);
        }
        catch (DatabaseException DE) {
            this.throwNewXAException(DE);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        boolean tmSuspend;
        boolean tmFail = (flags & 0x20000000) != 0;
        boolean tmSuccess = (flags & 0x4000000) != 0;
        boolean bl = tmSuspend = (flags & 0x2000000) != 0;
        if (tmFail && tmSuccess || (tmFail || tmSuccess) && tmSuspend) {
            throw new XAException(-5);
        }
        try {
            Transaction txn = this.environmentImpl.getTxnManager().unsetTxnForThread();
            if (txn == null) {
                boolean isSuspended;
                txn = this.getXATransaction(xid);
                boolean bl2 = isSuspended = txn != null && txn.getTxn().isSuspended();
                if (!isSuspended) {
                    throw new XAException(-4);
                }
            }
            if (tmFail) {
                txn.getTxn().setOnlyAbortable();
            }
            if (tmSuspend) {
                txn.getTxn().setSuspended(true);
            }
        }
        catch (DatabaseException DE) {
            this.throwNewXAException(DE);
        }
    }

    public void forget(Xid xid) throws XAException {
        throw new XAException(-4);
    }

    public boolean isSameRM(XAResource rm) throws XAException {
        try {
            this.checkEnv();
        }
        catch (DatabaseException DE) {
            this.throwNewXAException(DE);
        }
        if (rm == null) {
            return false;
        }
        if (!(rm instanceof XAEnvironment)) {
            return false;
        }
        return this.environmentImpl == DbInternal.envGetEnvironmentImpl((XAEnvironment)rm);
    }

    public int prepare(Xid xid) throws XAException {
        try {
            this.checkEnv();
            Transaction txn = this.getXATransaction(xid);
            if (txn == null) {
                throw new XAException("No transaction found for " + xid + " during prepare.");
            }
            txn.getTxn().prepare(xid);
            return 0;
        }
        catch (DatabaseException DE) {
            this.throwNewXAException(DE);
            return 0;
        }
    }

    public Xid[] recover(int flags) throws XAException {
        boolean tmEndRScan;
        boolean tmStartRScan = (flags & 0x1000000) != 0;
        boolean bl = tmEndRScan = (flags & 0x800000) != 0;
        if (tmStartRScan && tmEndRScan || !tmStartRScan && !tmEndRScan && flags != 0) {
            throw new XAException(-5);
        }
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.environmentImpl.getTxnManager().XARecover();
        }
        catch (DatabaseException DE) {
            this.throwNewXAException(DE);
            return null;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.checkEnv();
            Transaction txn = this.getXATransaction(xid);
            if (txn == null) {
                throw new XAException("No transaction found for " + xid + " during abort.");
            }
            this.removeReferringHandle(txn);
            txn.getTxn().abort(xid);
        }
        catch (DatabaseException DE) {
            this.throwNewXAException(DE);
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return (int)((this.getConfig().getTxnTimeout() + 999999L) / 1000000L);
        }
        catch (Exception DE) {
            this.throwNewXAException(DE);
            return 0;
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(Xid xid, int flags) throws XAException {
        boolean tmResume;
        boolean tmJoin = (flags & 0x200000) != 0;
        boolean bl = tmResume = (flags & 0x8000000) != 0;
        if (xid == null || tmJoin && tmResume || !tmJoin && !tmResume && flags != 0) {
            throw new XAException(-5);
        }
        try {
            Transaction txn = this.getXATransaction(xid);
            TxnManager txnMgr = this.environmentImpl.getTxnManager();
            if (flags == 0) {
                if (txn != null) throw new XAException(-8);
                txn = this.beginTransaction(null, null);
                this.setXATransaction(xid, txn);
            } else if (tmJoin) {
                if (txn == null) {
                    throw new XAException(-4);
                }
                if (txnMgr.getTxnForThread() != null) {
                    throw new XAException(-6);
                }
            } else if (tmResume) {
                if (txn == null) {
                    throw new XAException(-4);
                }
                if (!txn.getTxn().isSuspended()) {
                    throw new XAException(-6);
                }
                txn.getTxn().setSuspended(false);
            }
            txnMgr.setTxnForThread(txn);
            return;
        }
        catch (DatabaseException DE) {
            this.throwNewXAException(DE);
        }
    }

    private void throwNewXAException(Exception E) throws XAException {
        XAException ret = new XAException(E.toString());
        ret.initCause(E);
        throw ret;
    }
}

