/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleFormat;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveArrayFormat
extends Format {
    private static final long serialVersionUID = 8285299924106073591L;
    private SimpleFormat componentFormat;

    PrimitiveArrayFormat(Class type) {
        super(type);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimensions() {
        return 1;
    }

    @Override
    public Format getComponentType() {
        return this.componentFormat;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        this.componentFormat = (SimpleFormat)catalog.getFormat(this.getType().getComponentType());
    }

    @Override
    void initialize(Catalog catalog) {
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    Object newInstance(EntityInput input, boolean rawAccess) {
        int len = input.readPackedInt();
        if (rawAccess) {
            return new RawObject((RawType)this, new Object[len]);
        }
        return this.componentFormat.newPrimitiveArray(len, input);
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        if (rawAccess) {
            Object[] a = ((RawObject)o).getElements();
            output.writePackedInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.componentFormat.writeObject(a[i], output, true);
            }
        } else {
            this.componentFormat.writePrimitiveArray(o, output);
        }
    }

    @Override
    void readObject(Object o, EntityInput input, boolean rawAccess) {
        if (rawAccess) {
            Object[] a = ((RawObject)o).getElements();
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.componentFormat.newInstance(input, true);
                this.componentFormat.readObject(a[i], input, true);
            }
        }
    }

    @Override
    void skipContents(EntityInput input) {
        int len = input.readPackedInt();
        this.componentFormat.skipPrimitiveArray(len, input);
    }

    @Override
    void copySecMultiKey(EntityInput input, Format keyFormat, Set results) {
        int len = input.readPackedInt();
        this.componentFormat.copySecMultiKeyPrimitiveArray(len, input, results);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PrimitiveArrayFormat) {
            PrimitiveArrayFormat o = (PrimitiveArrayFormat)other;
            return super.equals(o);
        }
        return false;
    }
}

