/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleFormat
extends Format {
    private static final long serialVersionUID = 4595245575868697702L;
    private boolean primitive;
    private SimpleFormat wrapperFormat;

    SimpleFormat(Class type, boolean primitive) {
        super(type);
        this.primitive = primitive;
    }

    void setWrapperFormat(SimpleFormat wrapperFormat) {
        this.wrapperFormat = wrapperFormat;
    }

    @Override
    Format getWrapperFormat() {
        return this.wrapperFormat;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog) {
    }

    @Override
    void readObject(Object o, EntityInput input, boolean rawAccess) {
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SimpleFormat) {
            SimpleFormat o = (SimpleFormat)other;
            return super.equals(o) && this.primitive == o.primitive;
        }
        return false;
    }

    Object newPrimitiveArray(int len, EntityInput input) {
        throw new UnsupportedOperationException();
    }

    void writePrimitiveArray(Object o, EntityOutput output) {
        throw new UnsupportedOperationException();
    }

    int getPrimitiveLength() {
        throw new UnsupportedOperationException();
    }

    void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    void skipPrimitiveArray(int len, EntityInput input) {
        input.skipFast(len * this.getPrimitiveLength());
    }

    void copySecMultiKeyPrimitiveArray(int len, EntityInput input, Set results) {
        int primLen = this.getPrimitiveLength();
        for (int i = 0; i < len; ++i) {
            DatabaseEntry entry = new DatabaseEntry(input.getBufferBytes(), input.getBufferOffset(), primLen);
            results.add(entry);
            input.skipFast(primLen);
        }
    }

    public static class FDate
    extends SimpleFormat {
        private static final long serialVersionUID = -5665773229869034145L;

        FDate() {
            super(Date.class, false);
        }

        Object newArray(int len) {
            return new Date[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return new Date(input.readLong());
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeLong(((Date)o).getTime());
        }

        void skipContents(EntityInput input) {
            input.skipFast(8);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }
    }

    public static class FString
    extends SimpleFormat {
        private static final long serialVersionUID = 5710392786480064612L;

        FString() {
            super(String.class, false);
        }

        Object newArray(int len) {
            return new String[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readString();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeString((String)o);
        }

        void skipContents(EntityInput input) {
            input.skipFast(input.getStringByteLength());
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            int len = input.getStringByteLength();
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), len);
            input.skipFast(len);
        }
    }

    public static class FChar
    extends SimpleFormat {
        private static final long serialVersionUID = -7609118195770005374L;

        FChar(boolean primitive) {
            super(primitive ? Character.TYPE : Character.class, primitive);
        }

        Object newArray(int len) {
            return new Character[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return Character.valueOf(input.readChar());
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeChar(((Character)o).charValue());
        }

        void skipContents(EntityInput input) {
            input.skipFast(2);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            char[] a = new char[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readChar();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            char[] a = (char[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeChar(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 2;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setChar(o, input.readChar());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeChar(field.getChar(o));
        }
    }

    public static class FDouble
    extends SimpleFormat {
        private static final long serialVersionUID = 646904456811041423L;

        FDouble(boolean primitive) {
            super(primitive ? Double.TYPE : Double.class, primitive);
        }

        Object newArray(int len) {
            return new Double[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readSortedDouble();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeSortedDouble(((Number)o).doubleValue());
        }

        void skipContents(EntityInput input) {
            input.skipFast(8);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            double[] a = new double[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readSortedDouble();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            double[] a = (double[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeSortedDouble(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 8;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setDouble(o, input.readSortedDouble());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeSortedDouble(field.getDouble(o));
        }
    }

    public static class FFloat
    extends SimpleFormat {
        private static final long serialVersionUID = 1033413049495053602L;

        FFloat(boolean primitive) {
            super(primitive ? Float.TYPE : Float.class, primitive);
        }

        Object newArray(int len) {
            return new Float[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return Float.valueOf(input.readSortedFloat());
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeSortedFloat(((Number)o).floatValue());
        }

        void skipContents(EntityInput input) {
            input.skipFast(4);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            float[] a = new float[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readSortedFloat();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            float[] a = (float[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeSortedFloat(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 4;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setFloat(o, input.readSortedFloat());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeSortedFloat(field.getFloat(o));
        }
    }

    public static class FLong
    extends SimpleFormat {
        private static final long serialVersionUID = 1872661106534776520L;

        FLong(boolean primitive) {
            super(primitive ? Long.TYPE : Long.class, primitive);
        }

        Object newArray(int len) {
            return new Long[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readLong();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeLong(((Number)o).longValue());
        }

        void skipContents(EntityInput input) {
            input.skipFast(8);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            long[] a = new long[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readLong();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            long[] a = (long[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeLong(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 8;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setLong(o, input.readLong());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeLong(field.getLong(o));
        }
    }

    public static class FInt
    extends SimpleFormat {
        private static final long serialVersionUID = 2695910006049980013L;

        FInt(boolean primitive) {
            super(primitive ? Integer.TYPE : Integer.class, primitive);
        }

        Object newArray(int len) {
            return new Integer[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readInt();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeInt(((Number)o).intValue());
        }

        void skipContents(EntityInput input) {
            input.skipFast(4);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            int[] a = new int[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readInt();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            int[] a = (int[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeInt(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 4;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setInt(o, input.readInt());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeInt(field.getInt(o));
        }
    }

    public static class FShort
    extends SimpleFormat {
        private static final long serialVersionUID = -4909138198491785624L;

        FShort(boolean primitive) {
            super(primitive ? Short.TYPE : Short.class, primitive);
        }

        Object newArray(int len) {
            return new Short[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readShort();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeShort(((Number)o).shortValue());
        }

        void skipContents(EntityInput input) {
            input.skipFast(2);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            short[] a = new short[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readShort();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            short[] a = (short[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeShort(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 2;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setShort(o, input.readShort());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeShort(field.getShort(o));
        }
    }

    public static class FByte
    extends SimpleFormat {
        private static final long serialVersionUID = 3651752958101447257L;

        FByte(boolean primitive) {
            super(primitive ? Byte.TYPE : Byte.class, primitive);
        }

        Object newArray(int len) {
            return new Byte[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readByte();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeByte(((Number)o).byteValue());
        }

        void skipContents(EntityInput input) {
            input.skipFast(1);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            byte[] a = new byte[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readByte();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            byte[] a = (byte[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeByte(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 1;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setByte(o, input.readByte());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeByte(field.getByte(o));
        }
    }

    public static class FBool
    extends SimpleFormat {
        private static final long serialVersionUID = -7724949525068533451L;

        FBool(boolean primitive) {
            super(primitive ? Boolean.TYPE : Boolean.class, primitive);
        }

        Object newArray(int len) {
            return new Boolean[len];
        }

        Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readBoolean();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeBoolean((Boolean)o);
        }

        void skipContents(EntityInput input) {
            input.skipFast(1);
        }

        void copySecKey(EntityInput input, EntityOutput output) {
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) {
            boolean[] a = new boolean[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readBoolean();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            boolean[] a = (boolean[])o;
            int len = a.length;
            output.writePackedInt(len);
            for (int i = 0; i < len; ++i) {
                output.writeBoolean(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 1;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setBoolean(o, input.readBoolean());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeBoolean(field.getBoolean(o));
        }
    }
}

