/*
 * Decompiled with CFR 0.152.
 */
package wrappers.catalina;

import java.security.Principal;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.RealmBase;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.security.Security;
import org.apache.slide.structure.ObjectNode;
import wrappers.catalina.SlideRealmPrincipal;

public final class SlideRealm
extends RealmBase {
    private static final String info = "wrappers.catalina.SlideRealm/1.2";
    private NamespaceAccessToken accessToken;
    private Content contentHelper;
    private Security securityHelper;
    private String usersPath;
    private CredentialsToken rootCredentials;
    private String namespace;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAccessToken(NamespaceAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public String getName() {
        return "Slide realm";
    }

    public boolean hasRole(Principal principal, String role) {
        CredentialsToken credToken = new CredentialsToken(principal);
        SlideTokenImpl slideToken = new SlideTokenImpl(credToken);
        try {
            return this.securityHelper.hasRole((SlideToken)slideToken, role);
        }
        catch (SlideException e) {
            return false;
        }
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.namespace == null) {
            this.namespace = this.container.getName();
        }
        if (this.accessToken == null) {
            this.accessToken = Domain.accessNamespace((SecurityToken)new SecurityToken((Object)this.container), (String)this.namespace);
        }
        if (this.accessToken == null) {
            throw new IllegalStateException("Invalid Slide Realm configuration : Couldn't access namespace " + this.namespace);
        }
        this.contentHelper = this.accessToken.getContentHelper();
        this.securityHelper = this.accessToken.getSecurityHelper();
        this.usersPath = this.accessToken.getNamespaceConfig().getUsersPath();
    }

    protected String getPassword(String username) {
        Principal userPrincipal = this.getPrincipal(username);
        CredentialsToken credToken = new CredentialsToken(userPrincipal);
        SlideTokenImpl slideToken = new SlideTokenImpl(credToken);
        try {
            ObjectNode user = this.securityHelper.getPrincipal((SlideToken)slideToken);
        }
        catch (SlideException e) {
            return null;
        }
        String passwordValue = null;
        try {
            NodeRevisionDescriptors revisionDescriptors = this.contentHelper.retrieve((SlideToken)slideToken, this.usersPath + "/" + username);
            NodeRevisionDescriptor revisionDescriptor = this.contentHelper.retrieve((SlideToken)slideToken, revisionDescriptors);
            NodeProperty password = revisionDescriptor.getProperty("password", "http://jakarta.apache.org/slide/");
            if (password != null) {
                passwordValue = (String)password.getValue();
            }
        }
        catch (SlideException e) {
            // empty catch block
        }
        if (passwordValue == null) {
            this.log("User " + username + " doesn't have his password property set : " + "can't authenticate");
        }
        return passwordValue;
    }

    protected Principal getPrincipal(String username) {
        return new SlideRealmPrincipal(username);
    }
}

