/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.host;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import smartrics.iotics.host.HostEndpoints;
import smartrics.iotics.host.ServiceRegistry;

public class HttpServiceRegistry
implements ServiceRegistry {
    private final OkHttpClient httpClient = new OkHttpClient();
    private final String registryUrl;

    public HttpServiceRegistry(String uri) {
        this.registryUrl = HttpServiceRegistry.makeRegistryURI(uri);
    }

    @Override
    public HostEndpoints find() throws IOException {
        Request request = new Request.Builder().url(this.registryUrl).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.code() > 399) {
                throw new IOException("not found");
            }
            Gson gson = new Gson();
            assert (response.body() != null);
            HostEndpoints hostEndpoints = (HostEndpoints)gson.fromJson(response.body().string(), HostEndpoints.class);
            return hostEndpoints;
        }
    }

    public String registryUrl() {
        return this.registryUrl;
    }

    public String toString() {
        return "HttpServiceRegistry{registryUrl='" + this.registryUrl + "'}";
    }

    private static String makeRegistryURI(String uri) {
        if (uri == null || uri.trim().isEmpty()) {
            throw new IllegalArgumentException("URI cannot be null or empty.");
        }
        try {
            String path;
            URI parsedUri = URI.create(uri.trim());
            if (parsedUri.getScheme() == null) {
                parsedUri = URI.create(String.format("https://%s", parsedUri));
            }
            String end = (path = parsedUri.getPath()) == null || !path.endsWith("/") ? "/index.json" : "index.json";
            return String.valueOf(parsedUri) + end;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error processing URI: " + uri, e);
        }
    }
}

