/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.host;

import io.grpc.ManagedChannel;
import java.time.Duration;
import smartrics.iotics.host.IoticsApi;
import smartrics.iotics.host.WrapperFactory;
import smartrics.iotics.host.grpc.HostConnection;
import smartrics.iotics.host.wrappers.FeedAPI;
import smartrics.iotics.host.wrappers.FeedAPIFuture;
import smartrics.iotics.host.wrappers.InputAPIFuture;
import smartrics.iotics.host.wrappers.InterestAPI;
import smartrics.iotics.host.wrappers.InterestAPIBlocking;
import smartrics.iotics.host.wrappers.MetaAPI;
import smartrics.iotics.host.wrappers.SearchAPI;
import smartrics.iotics.host.wrappers.TwinAPIFuture;

public class IoticsApiImpl
implements IoticsApi {
    private final TwinAPIFuture twinAPIFuture;
    private final FeedAPIFuture feedAPIFuture;
    private final FeedAPI feedAPI;
    private final InputAPIFuture inputAPIFuture;
    private final InterestAPI interestAPI;
    private final InterestAPIBlocking interestAPIBlocking;
    private final SearchAPI searchAPI;
    private final MetaAPI metaAPI;
    private final HostConnection connection;

    public IoticsApiImpl(HostConnection connection) {
        this.connection = connection;
        ManagedChannel channel = connection.getGrpcChannel();
        this.twinAPIFuture = WrapperFactory.newTwinAPIFuture(channel);
        this.feedAPIFuture = WrapperFactory.newFeedAPIFuture(channel);
        this.feedAPI = WrapperFactory.newFeedApi(channel);
        this.inputAPIFuture = WrapperFactory.newInputAPIFuture(channel);
        this.metaAPI = WrapperFactory.newMetaAPI(channel);
        this.interestAPI = WrapperFactory.newInterestAPI(channel);
        this.interestAPIBlocking = WrapperFactory.newInterestAPIBlocking(channel);
        this.searchAPI = WrapperFactory.newSearchAPI(channel);
    }

    @Override
    public void stop(Duration timeout) {
        try {
            this.connection.shutdown(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Failed to shut down connection within the provided timeout: " + String.valueOf(timeout), e);
        }
    }

    @Override
    public TwinAPIFuture twinAPIFuture() {
        return this.twinAPIFuture;
    }

    @Override
    public FeedAPIFuture feedAPIFuture() {
        return this.feedAPIFuture;
    }

    @Override
    public FeedAPI feedAPI() {
        return this.feedAPI;
    }

    @Override
    public InputAPIFuture inputAPIFuture() {
        return this.inputAPIFuture;
    }

    @Override
    public InterestAPI interestAPI() {
        return this.interestAPI;
    }

    @Override
    public InterestAPIBlocking interestAPIBlocking() {
        return this.interestAPIBlocking;
    }

    @Override
    public SearchAPI searchAPI() {
        return this.searchAPI;
    }

    @Override
    public MetaAPI metaAPI() {
        return this.metaAPI;
    }
}

