/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.host.grpc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import smartrics.iotics.host.grpc.HostConnection;
import smartrics.iotics.host.grpc.HostManagedChannelBuilderFactory;
import smartrics.iotics.identity.IdentityManager;
import smartrics.iotics.identity.SimpleConfig;
import smartrics.iotics.identity.SimpleIdentityManager;

public class HostConnectionImpl
implements HostConnection {
    private final ManagedChannel channel;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("token-refresh-%d").build());

    public HostConnectionImpl(String grpcEndpoint, IdentityManager sim, Duration tokenValidityDuration) {
        ManagedChannelBuilder<?> channelBuilder = HostConnectionImpl.newHostManagedChannelBuilderFactory(sim, this.scheduler, grpcEndpoint, tokenValidityDuration);
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("iot-grpc-%d").build());
        this.channel = channelBuilder.executor((Executor)executor).keepAliveWithoutCalls(true).build();
    }

    public HostConnectionImpl(String grpcEndpoint, SimpleConfig userConf, SimpleConfig agentConf, Duration tokenValidityDuration) {
        this(grpcEndpoint, (IdentityManager)SimpleIdentityManager.Builder.anIdentityManager().withAgentKeyID(agentConf.keyId()).withUserKeyID(userConf.keyId()).withAgentKeyName(agentConf.keyName()).withUserKeyName(userConf.keyName()).build(), tokenValidityDuration);
    }

    public static ManagedChannelBuilder<?> newHostManagedChannelBuilderFactory(IdentityManager sim, ScheduledExecutorService scheduler, String grpcEndpoint, Duration tokenValidityDuration) {
        return new HostManagedChannelBuilderFactory().withIdentityManager(sim).withScheduler(scheduler).withSGrpcEndpoint(grpcEndpoint).withTokenTokenDuration(tokenValidityDuration).makeManagedChannelBuilder();
    }

    @Override
    public ManagedChannel getGrpcChannel() {
        return this.channel;
    }

    @Override
    public void shutdown(Duration wait) throws InterruptedException {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(wait.getSeconds(), TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.scheduler.shutdownNow();
        }
        this.channel.shutdown();
        if (!this.channel.awaitTermination(wait.getSeconds(), TimeUnit.SECONDS)) {
            this.channel.shutdownNow();
        }
    }
}

