/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.host.grpc;

import io.grpc.ManagedChannelBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import smartrics.iotics.host.grpc.TokenInjectorClientInterceptor;
import smartrics.iotics.host.grpc.token.TokenTimerScheduler;
import smartrics.iotics.host.grpc.token.TokenTimerSchedulerBuilder;
import smartrics.iotics.identity.IdentityManager;

public class HostManagedChannelBuilderFactory {
    private Duration tokenDuration;
    private IdentityManager sim;
    private String grpcEndpoint;
    private String userAgent;
    private ScheduledExecutorService scheduler;

    public HostManagedChannelBuilderFactory withSGrpcEndpoint(String endpoint) {
        this.grpcEndpoint = endpoint;
        return this;
    }

    public HostManagedChannelBuilderFactory withScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public HostManagedChannelBuilderFactory withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HostManagedChannelBuilderFactory withIdentityManager(IdentityManager sim) {
        this.sim = sim;
        return this;
    }

    public HostManagedChannelBuilderFactory withTokenTokenDuration(Duration tokenDuration) {
        this.tokenDuration = tokenDuration;
        return this;
    }

    public ManagedChannelBuilder<?> makeManagedChannelBuilder() {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)this.grpcEndpoint);
        TokenTimerScheduler tokenScheduler = TokenTimerSchedulerBuilder.aTokenTimerScheduler().withScheduler(this.scheduler).withDuration(this.tokenDuration).withIdentityManager(this.sim).build();
        tokenScheduler.schedule();
        TokenInjectorClientInterceptor tokenInjectorClientInterceptor = new TokenInjectorClientInterceptor(tokenScheduler);
        ArrayList<TokenInjectorClientInterceptor> interceptorList = new ArrayList<TokenInjectorClientInterceptor>();
        interceptorList.add(tokenInjectorClientInterceptor);
        builder.intercept(interceptorList);
        builder.userAgent(Objects.requireNonNullElseGet(this.userAgent, () -> "UserAgent=" + this.sim.agentIdentity().did()));
        return builder;
    }
}

