/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.host.grpc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class ListenableFutureAdapter<T> {
    private final CompletableFuture<T> completableFuture;

    public ListenableFutureAdapter(ListenableFuture<T> listenableFuture) {
        this(listenableFuture, MoreExecutors.directExecutor());
    }

    public ListenableFutureAdapter(final ListenableFuture<T> listenableFuture, Executor executor) {
        this.completableFuture = new CompletableFuture<T>(this){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(cancelled);
                return cancelled;
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                ListenableFutureAdapter.this.completableFuture.complete(result);
            }

            public void onFailure(@NotNull Throwable t) {
                ListenableFutureAdapter.this.completableFuture.completeExceptionally(t);
            }
        }, (Executor)executor);
    }

    public CompletableFuture<T> getCompletableFuture() {
        return this.completableFuture;
    }

    public static <T> CompletableFuture<T> toCompletable(ListenableFuture<T> listenableFuture) {
        ListenableFutureAdapter<T> listenableFutureAdapter = new ListenableFutureAdapter<T>(listenableFuture);
        return listenableFutureAdapter.getCompletableFuture();
    }
}

