/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.host.grpc.token;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import smartrics.iotics.host.grpc.token.TokenScheduler;
import smartrics.iotics.identity.IdentityManager;

public class TokenTimerScheduler
implements TokenScheduler {
    private final ScheduledExecutorService scheduler;
    private final IdentityManager identityManager;
    private final Duration duration;
    private final AtomicReference<String> validToken;

    TokenTimerScheduler(IdentityManager identityManager, Duration duration, ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        this.identityManager = identityManager;
        this.validToken = new AtomicReference();
        this.duration = duration;
    }

    @Override
    public void schedule() {
        if (this.scheduler == null) {
            throw new IllegalStateException("null scheduler");
        }
        this.scheduler.scheduleAtFixedRate(() -> this.validToken.set(this.identityManager.newAuthenticationToken(this.duration)), 0L, this.duration.toMillis() - 10L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void cancel() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public String validToken() {
        String value = this.validToken.get();
        if (value == null) {
            throw new IllegalStateException("not scheduled");
        }
        return value;
    }
}

