/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.host.grpc.token;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import smartrics.iotics.host.grpc.token.TokenTimerScheduler;
import smartrics.iotics.identity.IdentityManager;

public final class TokenTimerSchedulerBuilder {
    private ScheduledExecutorService scheduler;
    private IdentityManager identityManager;
    private Duration duration;

    private TokenTimerSchedulerBuilder() {
    }

    public static TokenTimerSchedulerBuilder aTokenTimerScheduler() {
        return new TokenTimerSchedulerBuilder();
    }

    public TokenTimerSchedulerBuilder withScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public TokenTimerSchedulerBuilder withIdentityManager(IdentityManager identityManager) {
        this.identityManager = identityManager;
        return this;
    }

    public TokenTimerSchedulerBuilder withDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public TokenTimerScheduler build() {
        return new TokenTimerScheduler(this.identityManager, this.duration, this.scheduler);
    }
}

