/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import smartrics.rest.fitnesse.fixture.RunnerVariablesProvider;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.ContentType;
import smartrics.rest.fitnesse.fixture.support.JSONBodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.TextBodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.XPathBodyTypeAdapter;

public class BodyTypeAdapterFactory {
    private final RunnerVariablesProvider variablesProvider;
    private Map<ContentType, BodyTypeAdapterCreator> contentTypeToBodyTypeAdapter = new HashMap<ContentType, BodyTypeAdapterCreator>();

    public BodyTypeAdapterFactory(RunnerVariablesProvider variablesProvider) {
        BodyTypeAdapterCreator jsonBodyTypeAdapterCreator = new BodyTypeAdapterCreator(){

            @Override
            public BodyTypeAdapter createBodyTypeAdapter() {
                return new JSONBodyTypeAdapter(BodyTypeAdapterFactory.this.variablesProvider);
            }
        };
        this.contentTypeToBodyTypeAdapter.put(ContentType.JS, jsonBodyTypeAdapterCreator);
        this.contentTypeToBodyTypeAdapter.put(ContentType.JSON, jsonBodyTypeAdapterCreator);
        this.contentTypeToBodyTypeAdapter.put(ContentType.XML, new BodyTypeAdapterCreator(){

            @Override
            public BodyTypeAdapter createBodyTypeAdapter() {
                return new XPathBodyTypeAdapter();
            }
        });
        this.contentTypeToBodyTypeAdapter.put(ContentType.TEXT, new BodyTypeAdapterCreator(){

            @Override
            public BodyTypeAdapter createBodyTypeAdapter() {
                return new TextBodyTypeAdapter();
            }
        });
        this.variablesProvider = variablesProvider;
    }

    public BodyTypeAdapter getBodyTypeAdapter(ContentType content, String charset) {
        BodyTypeAdapterCreator creator = this.contentTypeToBodyTypeAdapter.get((Object)content);
        if (creator == null) {
            throw new IllegalArgumentException("Content-Type is UNKNOWN.  Unable to find a BodyTypeAdapter to instantiate.");
        }
        BodyTypeAdapter instance = creator.createBodyTypeAdapter();
        if (charset != null) {
            instance.setCharset(charset);
        } else {
            instance.setCharset(Charset.defaultCharset().name());
        }
        return instance;
    }

    static interface BodyTypeAdapterCreator {
        public BodyTypeAdapter createBodyTypeAdapter();
    }
}

