/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.util.HashMap;
import java.util.Map;
import smartrics.rest.fitnesse.fixture.support.Tools;

public final class Config {
    public static final String DEFAULT_CONFIG_NAME = "default";
    private static final Map<String, Config> CONFIGURATIONS = new HashMap<String, Config>();
    private final String name;
    private Map<String, String> data;

    public static Config getConfig() {
        return Config.getConfig(DEFAULT_CONFIG_NAME);
    }

    public static Config getConfig(String name) {
        Config namedConfig;
        if (name == null) {
            name = DEFAULT_CONFIG_NAME;
        }
        if ((namedConfig = CONFIGURATIONS.get(name)) == null) {
            namedConfig = new Config(name);
            CONFIGURATIONS.put(name, namedConfig);
        }
        return namedConfig;
    }

    private Config(String name) {
        this.name = name;
        this.data = new HashMap<String, String>();
    }

    public String getName() {
        return this.name;
    }

    public void add(String key, String value) {
        this.data.put(key, value);
    }

    public String get(String key) {
        return this.data.get(key);
    }

    public String get(String key, String def) {
        String v = this.get(key);
        if (v == null) {
            v = def;
        }
        return v;
    }

    public Long getAsLong(String key, Long def) {
        String val = this.get(key);
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Boolean getAsBoolean(String key, Boolean def) {
        String val = this.get(key);
        if (val == null) {
            return def;
        }
        return Boolean.parseBoolean(val);
    }

    public Integer getAsInteger(String key, Integer def) {
        String val = this.get(key);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Map<String, String> getAsMap(String key, Map<String, String> def) {
        String val = this.get(key);
        try {
            return Tools.convertStringToMap(val, "\n", "=", true);
        }
        catch (RuntimeException e) {
            return def;
        }
    }

    public void clear() {
        this.data.clear();
    }

    public String toString() {
        return "[name=" + this.getName() + "] " + this.data.toString();
    }
}

