/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import smartrics.rest.client.RestData;
import smartrics.rest.fitnesse.fixture.support.RestDataTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.Tools;

public class HeadersTypeAdapter
extends RestDataTypeAdapter {
    public boolean equals(Object expectedObj, Object actualObj) {
        if (expectedObj == null || actualObj == null) {
            return false;
        }
        Collection expected = (Collection)expectedObj;
        Collection actual = (Collection)actualObj;
        for (RestData.Header k : expected) {
            RestData.Header aHdr = this.find(actual, k);
            if (aHdr != null) continue;
            this.addError("not found: [" + k.getName() + " : " + k.getValue() + "]");
        }
        return this.getErrors().size() == 0;
    }

    private RestData.Header find(Collection<RestData.Header> actual, RestData.Header k) {
        for (RestData.Header h : actual) {
            boolean nameMatches = h.getName().equals(k.getName());
            boolean valueMatches = Tools.regex(h.getValue(), k.getValue());
            if (!nameMatches || !valueMatches) continue;
            return h;
        }
        return null;
    }

    public Object parse(String s) throws Exception {
        ArrayList<RestData.Header> expected = new ArrayList<RestData.Header>();
        if (!"".equals(s.trim())) {
            String[] nvpArray;
            String expStr = Tools.fromHtml(s.trim());
            for (String nvp : nvpArray = expStr.split("\n")) {
                try {
                    String[] nvpEl = nvp.split(":", 2);
                    expected.add(new RestData.Header(nvpEl[0].trim(), nvpEl[1].trim()));
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("Each entry in the must be separated by \\n and each entry must be expressed as a name:value");
                }
            }
        }
        return expected;
    }

    public String toString(Object obj) {
        StringBuffer b = new StringBuffer();
        List list = (List)obj;
        for (RestData.Header h : list) {
            b.append(h.getName()).append(" : ").append(h.getValue()).append("\n");
        }
        return b.toString().trim();
    }
}

