/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.params.HttpClientParams;
import smartrics.rest.fitnesse.fixture.support.Config;

public class HttpClientBuilder {
    public static final Integer DEFAULT_SO_TO = 3000;
    public static final Integer DEFAULT_PROXY_PORT = 80;

    public HttpClient createHttpClient(Config config) {
        HttpClient client = this.createConfiguredClient(config);
        if (config != null) {
            this.configureHost(config, client);
            this.configureCredentials(config, client);
        }
        return client;
    }

    private HttpClient createConfiguredClient(Config config) {
        HttpClientParams params = new HttpClientParams();
        params.setSoTimeout(DEFAULT_SO_TO.intValue());
        if (config != null) {
            params.setSoTimeout(config.getAsInteger("http.client.connection.timeout", DEFAULT_SO_TO).intValue());
        }
        HttpClient client = new HttpClient(params);
        return client;
    }

    private void configureHost(Config config, HttpClient client) {
        HostConfiguration hostConfiguration = client.getHostConfiguration();
        String proxyHost = config.get("http.proxy.host");
        if (proxyHost != null) {
            int proxyPort = config.getAsInteger("http.proxy.port", DEFAULT_PROXY_PORT);
            hostConfiguration.setProxy(proxyHost, proxyPort);
        }
        HostParams hostParams = new HostParams();
        hostConfiguration.setParams(hostParams);
    }

    private void configureCredentials(Config config, HttpClient client) {
        String username = config.get("http.basicauth.username");
        String password = config.get("http.basicauth.password");
        if (username != null && password != null) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
    }
}

