/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.util.List;
import smartrics.rest.fitnesse.fixture.RunnerVariablesProvider;
import smartrics.rest.fitnesse.fixture.support.JavascriptWrapper;
import smartrics.rest.fitnesse.fixture.support.Tools;
import smartrics.rest.fitnesse.fixture.support.XPathBodyTypeAdapter;

public class JSONBodyTypeAdapter
extends XPathBodyTypeAdapter {
    private boolean forceJsEvaluation = false;
    private final JavascriptWrapper wrapper;

    public JSONBodyTypeAdapter(RunnerVariablesProvider variablesProvider) {
        this.wrapper = new JavascriptWrapper(variablesProvider);
    }

    @Override
    protected boolean eval(String expr, String json) {
        if (!this.forceJsEvaluation && Tools.isValidXPath(this.getContext(), expr) && !this.wrapper.looksLikeAJsExpression(expr)) {
            throw new IllegalArgumentException("XPath expectations in JSON content are not supported anymore. Please use JavaScript expressions.");
        }
        Object exprResult = this.wrapper.evaluateExpression(json, expr);
        if (exprResult == null) {
            return false;
        }
        return Boolean.parseBoolean(exprResult.toString());
    }

    @Override
    public Object parse(String possibleJsContent) throws Exception {
        if (possibleJsContent == null || possibleJsContent.trim().indexOf("/* javascript */") < 0) {
            this.forceJsEvaluation = false;
            return super.parse(possibleJsContent);
        }
        this.forceJsEvaluation = true;
        String content = Tools.fromHtml(possibleJsContent.trim());
        return content;
    }

    @Override
    public boolean equals(Object expected, Object actual) {
        if (this.checkNoBody(expected)) {
            return this.checkNoBody(actual);
        }
        if (this.checkNoBody(actual)) {
            return this.checkNoBody(expected);
        }
        if (expected instanceof List) {
            return super.equals(expected, actual);
        }
        boolean result = false;
        if (expected instanceof String && !(result = this.eval(expected.toString(), actual.toString()))) {
            this.addError("not found: '" + expected.toString() + "'");
        }
        return result;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null || obj.toString().trim().equals("")) {
            return "no-body";
        }
        return obj.toString();
    }

    @Override
    public String toXmlString(String content) {
        return Tools.fromJSONtoXML(content);
    }
}

